package gov.va.fnod.model;

import java.io.Serializable;
import java.sql.Timestamp;

/**
 * This DTO class represents the data that needs to be returned to the UI layer in response to a
 * 'Search Database' inquiry.
 * 
 * @author VHAISLHODGEJ
 *
 */
public class SearchFNODRecordsResult implements Serializable {
	
	private static final long serialVersionUID = 8051625680665608876L;

	
	private Long caseId;
	private String firstName;
	private String lastName;
	private String middleName;
	private String suffix;
	private String militaryServiceNum;
	private String veteranClaimNum;
	private String socialSecurityNum;
	private Timestamp dateOfBirth;
	private Timestamp dateOfDeath;
	private String lockedStatus;
	private String caseType;
	private Timestamp fnodCreatedDt;

	

	public SearchFNODRecordsResult() {
		super();
	}	
	
	
	
	/**
	 * Constructor provided for the sake of querying JPA directly into this DTO
	 * @param caseId
	 * @param firstName
	 * @param lastName
	 * @param middleName
	 * @param suffix
	 * @param dateOfBirth
	 * @param dateOfDeath
	 * @param socialSecurityNum
	 * @param veteranClaimNum
	 * @param militaryServiceNum
	 * @param lockedStatus
	 */
	public SearchFNODRecordsResult(Long caseId, String firstName, String lastName,
			String middleName, String suffix, Timestamp dateOfBirth,
			Timestamp dateOfDeath, String socialSecurityNum,
			String veteranClaimNum, String militaryServiceNum,
			String lockedStatus,
			String caseType) {
		super();
		this.caseId = caseId;
		this.firstName = firstName;
		this.lastName = lastName;
		this.middleName = middleName;
		this.suffix = suffix;
		this.dateOfBirth = dateOfBirth;
		this.dateOfDeath = dateOfDeath;
		this.socialSecurityNum = socialSecurityNum;
		this.veteranClaimNum = veteranClaimNum;
		this.militaryServiceNum = militaryServiceNum;
		this.lockedStatus = lockedStatus;
		this.caseType = caseType;
	}




	public Long getCaseId() {
		return caseId;
	}
	public void setCaseId(Long caseId) {
		this.caseId = caseId;
	}
	public String getFirstName() {
		return firstName;
	}
	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}
	public String getLastName() {
		return lastName;
	}
	public void setLastName(String lastName) {
		this.lastName = lastName;
	}
	public String getMiddleName() {
		return middleName;
	}
	public void setMiddleName(String middleName) {
		this.middleName = middleName;
	}
	public String getSuffix() {
		return suffix;
	}
	public void setSuffix(String suffix) {
		this.suffix = suffix;
	}
	public String getMilitaryServiceNum() {
		return militaryServiceNum;
	}
	public void setMilitaryServiceNum(String militaryServiceNum) {
		this.militaryServiceNum = militaryServiceNum;
	}
	public String getVeteranClaimNum() {
		return veteranClaimNum;
	}
	public void setVeteranClaimNum(String veteranClaimNum) {
		this.veteranClaimNum = veteranClaimNum;
	}
	public String getSocialSecurityNum() {
		return socialSecurityNum;
	}
	public void setSocialSecurityNum(String socialSecurityNum) {
		this.socialSecurityNum = socialSecurityNum;
	}
	public Timestamp getDateOfBirth() {
		return dateOfBirth;
	}
	public void setDateOfBirth(Timestamp dateOfBirth) {
		this.dateOfBirth = dateOfBirth;
	}
	public Timestamp getDateOfDeath() {
		return dateOfDeath;
	}
	public void setDateOfDeath(Timestamp dateOfDeath) {
		this.dateOfDeath = dateOfDeath;
	}
	
	public String getLockedStatus() {
		return lockedStatus;
	}
	public void setLockedStatus(String lockedStatus) {
		this.lockedStatus = lockedStatus;
	}

	public String getCaseType() {
		return caseType;
	}
	public void setCaseType(String caseType) {
		this.caseType = caseType;
	}


	public Timestamp getFnodCreatedDt() {
		return fnodCreatedDt;
	}



	public void setFnodCreatedDt(Timestamp fnodCreatedDt) {
		this.fnodCreatedDt = fnodCreatedDt;
	}
}
