package gov.va.fnod.model;

import java.io.Serializable;
import java.sql.Timestamp;

/**
 * This DTO carries the search criteria from the UI layer to the Service layer of the
 * application.  It is used in the 'Search Database' use case.
 * 
 * @author VHAISLHODGEJ
 *
 */
public class SearchFNODRecordsCriteria implements Serializable {
	
	private static final long serialVersionUID = 2465545476866710287L;

	private String caseId;
	private Timestamp fnodCreatedDate;
	private String lastName;
	private String firstName;
	private String middleName;
	private String suffixName;
	private Timestamp birthDate;
	private Timestamp deathDate;
	private String socialSecurityNumber;
	private String veteranCaseNumber;
	private String militaryServiceNumber;
	private String selectedUserName;
	
	
	public SearchFNODRecordsCriteria() {
		super();
	}

	public String getCaseId() {
		return caseId;
	}

	public void setCaseId(String caseId) {
		this.caseId = caseId;
	}

	public Timestamp getFnodCreatedDate() {
		return fnodCreatedDate;
	}

	public void setFnodCreatedDate(Timestamp fnodCreatedDate) {
		this.fnodCreatedDate = fnodCreatedDate;
	}

	public String getLastName() {
		return lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	public String getFirstName() {
		return firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public String getMiddleName() {
		return middleName;
	}

	public void setMiddleName(String middleName) {
		this.middleName = middleName;
	}

	public String getSuffixName() {
		return suffixName;
	}

	public void setSuffixName(String suffixName) {
		this.suffixName = suffixName;
	}

	public Timestamp getBirthDate() {
		return birthDate;
	}

	public void setBirthDate(Timestamp birthDate) {
		this.birthDate = birthDate;
	}

	public Timestamp getDeathDate() {
		return deathDate;
	}

	public void setDeathDate(Timestamp deathDate) {
		this.deathDate = deathDate;
	}

	public String getSocialSecurityNumber() {
		return socialSecurityNumber;
	}

	public void setSocialSecurityNumber(String socialSecurityNumber) {
		this.socialSecurityNumber = socialSecurityNumber;
	}

	public String getVeteranClaimNumber() {
		return veteranCaseNumber;
	}

	public void setVeteranClaimNumber(String veteranCaseNumber) {
		this.veteranCaseNumber = veteranCaseNumber;
	}

	public String getMilitaryServiceNumber() {
		return militaryServiceNumber;
	}

	public void setMilitaryServiceNumber(String militaryServiceNumber) {
		this.militaryServiceNumber = militaryServiceNumber;
	}

	public String getSelectedUserName() {
		return selectedUserName;
	}

	public void setSelectedUserName(String selectedUserName) {
		this.selectedUserName = selectedUserName;
	}

}
	
	