package gov.va.fnod.model;



import java.io.Serializable;



/**

 * This class contains the data elements needed to manage a user session with the sampling/auditing subsystem.

 * The caseId is intended to be used to retrieve the case data needing to be review, while the sample id is

 * used to keep track of the specific sample record, allowing for FIFO processing and the ability to skip a simple

 * item to be reviewed at a later time.

 */

public class SampleItem implements Serializable {



	private static final long serialVersionUID = 4425790323873747757L;

	

	private Long sampleId = Long.valueOf(0L);

	private Long caseId = Long.valueOf(0L);

	

	public SampleItem() {

		super();

	}

		

	public Long getSampleId() {

		return sampleId;

	}

	

	public void setSampleId(Long sampleId) {

		this.sampleId = sampleId;

	}

	

	public Long getCaseId() {

		return caseId;

	}

	

	public void setCaseId(Long caseId) {

		this.caseId = caseId;

	}

	

}

