package gov.va.fnod.model;

import java.io.Serializable;
import java.sql.Timestamp;

public class SampleCriteria implements Serializable {
	
	private static final long serialVersionUID = 4270224396916468177L;

	private Timestamp fromDate;
	private Timestamp toDate;
	private Long sourceSystemId;
	private Long caseTypeId;
	private Long regionId;
	private Long regionalOfficeId;
	private int maxRows;
	private double samplePercent;
	private String username;
	
	public SampleCriteria() {
		super();
	}
	
	public SampleCriteria(
			Timestamp fromDate, 
			Timestamp toDate, 
			Long sourceSystemId, 
			Long caseTypeId, 
			Long regionId, 
			Long regionalOfficeId, 
			int maxRows, 
			double samplePercent,
			String username) { 
		
		this.fromDate = fromDate;
		this.toDate = toDate;
		this.sourceSystemId = sourceSystemId;
		this.caseTypeId = caseTypeId;
		this.regionId = regionId;
		this.regionalOfficeId = regionalOfficeId;
		this.maxRows = maxRows;
		this.samplePercent = samplePercent;
		this.username = username;
	}

	public Timestamp getFromDate() {
		return fromDate;
	}

	public void setFromDate(Timestamp fromDate) {
		this.fromDate = fromDate;
	}

	public Timestamp getToDate() {
		return toDate;
	}

	public void setToDate(Timestamp toDate) {
		this.toDate = toDate;
	}

	public Long getSourceSystemId() {
		return sourceSystemId;
	}

	public void setSourceSystemId(Long sourceSystemId) {
		this.sourceSystemId = sourceSystemId;
	}

	public Long getCaseTypeId() {
		return caseTypeId;
	}

	public void setCaseTypeId(Long caseTypeId) {
		this.caseTypeId = caseTypeId;
	}

	public Long getRegionId() {
		return regionId;
	}

	public void setRegionId(Long regionId) {
		this.regionId = regionId;
	}

	public Long getRegionalOfficeId() {
		return regionalOfficeId;
	}

	public void setRegionalOfficeId(Long regionalOfficeId) {
		this.regionalOfficeId = regionalOfficeId;
	}

	public int getMaxRows() {
		return maxRows;
	}

	public void setMaxRows(int maxRows) {
		this.maxRows = maxRows;
	}

	public double getSamplePercent() {
		return samplePercent;
	}

	public void setSamplePercent(double samplePercent) {
		this.samplePercent = samplePercent;
	}

	public String getUsername() {
		return username;
	}

	public void setUsername(String username) {
		this.username = username;
	}
}
