package gov.va.fnod.model;

import java.util.Map;

import org.apache.log4j.Logger;

public abstract class PasswordManagerBase {
	
	public PasswordManagerBase(PasswordHashable passwordHasher,
			Validator passwordValidator) {
		this.passwordHasher = passwordHasher;
		this.passwordValidator = passwordValidator;
	}

	protected PasswordHashable passwordHasher;
	
	protected Validator passwordValidator;
	
	protected static final Logger log = Logger.getLogger(PasswordManagerBase.class);

	public abstract  Map<ErrorCode, String> login(String password, PasswordData passwordData);

	public abstract  Map<ErrorCode, String> changePassword(String newPassword, PasswordData passwordData);
	
	public abstract  Map<ErrorCode, String> createUser(String username, String password, PasswordParameters passwordParameters);

	public abstract  Map<ErrorCode, String> resetPassword(String password, PasswordParameters passwordParameters);

	/**
	 * @return the passwordHasher
	 */
	public PasswordHashable getPasswordHasher() {
		return passwordHasher;
	}

	/**
	 * @param passwordHasher the passwordHasher to set
	 */
	public void setPasswordHasher(PasswordHashable passwordHasher) {
		this.passwordHasher = passwordHasher;
	}

	/**
	 * @return the passwordValidator
	 */
	public Validator getPasswordValidator() {
		return passwordValidator;
	}

	/**
	 * @param passwordValidator the passwordValidator to set
	 */
	public void setPasswordValidator(Validator passwordValidator) {
		this.passwordValidator = passwordValidator;
	}

}
