package gov.va.fnod.model;

import java.util.Map;

public class PasswordManager extends PasswordManagerBase {

	public PasswordManager(PasswordHashable passwordHasher,
			Validator passwordValidator) {
		super(passwordHasher, passwordValidator);
	}

	/**
	 * validate the user login
	 */
	@Override
	public Map<ErrorCode, String> login(String password,
			PasswordData passwordData) {
		passwordValidator.setPasswordHasher(passwordHasher);
		Map<ErrorCode, String> errors = passwordValidator.validatePassword(
				password, passwordData);
		return errors;
	}

	/**
	 * validate change password
	 */
	@Override
	public Map<ErrorCode, String> changePassword(String newPassword,
			PasswordData passwordData) {
		passwordValidator.setPasswordHasher(passwordHasher);
		Map<ErrorCode, String> errors = passwordValidator
				.validateChangePassword(newPassword, passwordData);
		return errors;
	}

	/**
	 * validate create user
	 */
	@Override
	public Map<ErrorCode, String> createUser(String username, String password,
			PasswordParameters passwordParams) {
		passwordValidator.setPasswordHasher(passwordHasher);
		Map<ErrorCode, String> errors = passwordValidator.validateCreateUser(
				username, password, passwordParams);
		return errors;
	}

	/**
	 * validate reset password
	 */
	@Override
	public Map<ErrorCode, String> resetPassword(String password,
			PasswordParameters passwordParams) {
		passwordValidator.setPasswordHasher(passwordHasher);
		Map<ErrorCode, String> errors = passwordValidator
				.validateResetPassword(password, passwordParams);
		return errors;
	}
}