package gov.va.fnod.model;

public interface PasswordHashable {

	/**
	 * compare the password hash to the password entered by the user
	 * 
	 * @param hashedPasswordHex
	 * @param password
	 * @return
	 */
	boolean comparePasswords(String hashedPasswordHex, String password);

	/**
	 * generate the seed using the SecureRandom
	 * 
	 * @return
	 */
	byte[] generateSeed();

	/**
	 * extract seed from the hashed password
	 * 
	 * @param hashedPassword
	 * @return
	 */
	byte[] extractSeed(String hashedPassword);

	/**
	 * extract the password from the hashed password
	 * 
	 * @param hashedPasswordHex
	 * @return
	 */
	byte[] extractPasswordHash(String hashedPasswordHex);

	/**
	 * hash the password - generate the seed and call hashpassword() passing the
	 * seed
	 * 
	 * @param password
	 * @param seed
	 * @return
	 */
	String hashPassword(String password);

	/**
	 * hash the password given a seed
	 * 
	 * @param password
	 * @param seed
	 * @return
	 */
	byte[] hashPassword(String password, byte[] seed);

}
