package gov.va.fnod.model;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

/**
 * Class containing common Date functions
 * 
 */
public class DateUtil {

	/**
	 * get the difference between the dates as number of days
	 * 
	 * @param date1
	 * @param date2
	 * @return
	 */
	public static long getDateDiffDays(Date date1, Date date2) {
		long diffDays = 0;
		diffDays = (date1.getTime() - date2.getTime()) / (1000 * 60 * 60 * 24);
		return diffDays;
	}

	/**
	 * get the difference between the dates in minutes
	 * 
	 * @param date1
	 * @param date2
	 * @return
	 */
	public static long getDateDiffMins(Date date1, Date date2) {
		long diffMins = 0;
		diffMins = (date1.getTime() - date2.getTime()) / (1000 * 60);
		return diffMins;

	}

	/**
	 * get the expiry date given time to live
	 * 
	 * @param ttl
	 * @return
	 */
	public static Timestamp getExpiryDate(int ttl) {
		Calendar today = Calendar.getInstance();
		today.add(Calendar.DATE, ttl);
		return new Timestamp(today.getTime().getTime());
	}

	/**
	 * get the current timestamp
	 * 
	 * @return
	 */
	public static Timestamp getCurrentTime() {
		return new Timestamp(new Date().getTime());
	}
}
