package gov.va.fnod.model;

import gov.va.fnod.model.fnoddata.Person;
import gov.va.fnod.util.OracleTimestampTimeZoneConverter;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;

public class CaseLinkData implements Serializable {
	
	private static final long serialVersionUID = -3785860903414778255L;
	
	
	private long caseId;
	private String description;
	private String nmi;
	private String sensitive;
	private Timestamp caseCreatedDt;
	private Timestamp caseLockedDt;
	private Person veteran;
	private String userName;
	private String lockedDt;
	private String createDt;
	
	public CaseLinkData() {
		super();
	}

	public CaseLinkData(long caseId, String userName, String description, String nmi, String sensitive, Person veteran, Timestamp caseCreatedDt, Timestamp caseLockedDt) {
		this.caseId = caseId;
		this.userName = userName;
		this.description = description;
		this.nmi = nmi;
		this.sensitive = sensitive;
		this.veteran = veteran;
		this.caseCreatedDt = caseCreatedDt;
		this.caseLockedDt = caseLockedDt;
	}
	public void copyTimeStampToDateFields() { 
		if(this.getCaseLockedDt() != null) { 
			this.lockedDt = OracleTimestampTimeZoneConverter.formatDateWithTimeZone(new Date(this.getCaseLockedDt().getTime()));
		}else { 
			this.lockedDt = null;
		}
		if(this.getCaseCreatedDt() != null) { 
			this.createDt = OracleTimestampTimeZoneConverter.formatDateWithTimeZone(new Date(this.getCaseCreatedDt().getTime()));
		}else { 
			this.createDt = null;
		}
	}
	
	
	public long getCaseId() {
		return caseId;
	}

	public void setCaseId(long caseId) {
		this.caseId = caseId;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}
	
	public String getNmi() {
		return nmi;
	}

	public void setNmi(String nmi) {
		this.nmi = nmi;
	}
	
	public String getSensitive() {
		return sensitive;
	}

	public void setSensitive(String sensitive) {
		this.sensitive = sensitive;
	}

	public Timestamp getCaseCreatedDt() {
		return caseCreatedDt;
	}

	public void setCaseCreatedDt(Timestamp caseCreatedDt) {
		this.caseCreatedDt = caseCreatedDt;
	}

	public String getVeteranName() {
		return veteran != null ? veteran.getDisplayName(): "";
	}

	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public Timestamp getCaseLockedDt() {
		return caseLockedDt;
	}

	public void setCaseLockedDt(Timestamp caseLockedDt) {
		this.caseLockedDt = caseLockedDt;
	}

	public Person getVeteran() {
		return veteran;
	}

	public void setVeteran(Person veteran) {
		this.veteran = veteran;
	}

	public String getLockedDt() {
		return lockedDt;
	}

	public void setLockedDt(String lockedDt) {
		this.lockedDt = lockedDt;
	}

	public String getCreateDt() {
		return createDt;
	}

	public void setCreateDt(String createDt) {
		this.createDt = createDt;
	}

	
}
