package gov.va.cem.docstorage.service;

import gov.va.cem.docstorage.model.SystemAccount;
import gov.va.cem.docstorage.model.UnitName;

import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

@EJB(name = "systemAccount", beanInterface = SystemAccountSession.class)
@Stateless
public class SystemAccountSessionBean implements SystemAccountSession {
	
	@PersistenceContext(unitName=UnitName.DOC_STORAGE)
	private EntityManager em;
	
	public SystemAccountSessionBean() {
		super();
	}
	
	/**
	 * @see gov.va.cem.docstorage.service.SystemAccountSession#getSystemAccount(java.lang.String)
	 */
	@Override
	public SystemAccount getSystemAccount(String accountName) {
		Query query = em.createNamedQuery(SystemAccount.BY_ACCT_NAME);
		query.setParameter("accountName", accountName);
		
		SystemAccount sysAcct = (SystemAccount) query.getSingleResult();
		
		if ( sysAcct == null ) {
			throw new IllegalStateException("System account not found");
		}
		
		return sysAcct;

	}

}
