package gov.va.cem.docstorage.service;


import gov.va.cem.docstorage.model.StorageSegment;
import gov.va.cem.docstorage.model.UnitName;

import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

@EJB(name = "storageSegment", beanInterface = StorageSegmentSession.class)
@Stateless
public class StorageSegmentSessionBean implements StorageSegmentSession {

	@PersistenceContext(unitName=UnitName.DOC_STORAGE) 
	EntityManager em;
	
	@Override
	public StorageSegment getNextAvailableSegement() {
		StorageSegment ss = (StorageSegment) em.createNamedQuery(StorageSegment.NextSegment).getSingleResult();
		if ( ss == null ) {
			throw new RuntimeException("Unable to allocate storage: segment not found");
		}
		
		return ss;
	}

	@Override
	public void markSegmentFull(long segmentId) {
		StorageSegment ss = em.find(StorageSegment.class, segmentId);
		if ( ss != null ) {
			ss.setIsFull("Y");
			em.merge(ss);
		}

	}

}
