package gov.va.cem.docstorage.model;



import java.io.Serializable;

import javax.persistence.*;





/**

 * The persistent class for the SYSTEM_ACCOUNT database table.

 * 

 */

@Entity

@Table(name="SYSTEM_ACCOUNT")

@NamedQueries ({

	@NamedQuery(name=SystemAccount.BY_ACCT_NAME,

			    query = "select a from SystemAccount a where a.accountName = :accountName")

})

public class SystemAccount implements Serializable {

	private static final long serialVersionUID = 1L;

	

	public static final String BY_ACCT_NAME = "SystemAccount.BY_ACCT_NAME";



	@Id

	@SequenceGenerator(name="SYSTEM_ACCOUNT_SYSTEMACCOUNTID_GENERATOR", sequenceName="SYSTEM_ACCOUNT_SEQ", allocationSize=1)

	@GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SYSTEM_ACCOUNT_SYSTEMACCOUNTID_GENERATOR")

	@Column(name="SYSTEM_ACCOUNT_ID", unique=true, nullable=false, precision=9)

	private long systemAccountId;



	@Column(name="ACCOUNT_NAME", unique=true, nullable=false, length=32)

	private String accountName;



    public SystemAccount() {

    }



	public long getSystemAccountId() {

		return this.systemAccountId;

	}



	public void setSystemAccountId(long systemAccountId) {

		this.systemAccountId = systemAccountId;

	}



	public String getAccountName() {

		return this.accountName;

	}



	public void setAccountName(String accountName) {

		this.accountName = accountName;

	}



}