package gov.va.cem.docstorage.model;



import java.io.Serializable;

import javax.persistence.*;





/**

 * The persistent class for the STORAGE_SEGMENT database table.

 * 

 */

@Entity

@Table(name="STORAGE_SEGMENT")

@NamedQueries ( {

	@NamedQuery(name=StorageSegment.NextSegment,

			    query="select s " +

			    		"from StorageSegment s " +

			    		"where s.isActive='Y' " +

			    		"  and s.isFull ='N' " +

			    		"order by s.storageSegmentId")

})

public class StorageSegment implements Serializable {

	private static final long serialVersionUID = 1L;

	

	public static final String NextSegment = "StorageSegment.NextSegment";



	@Id

	@SequenceGenerator(name="STORAGE_SEGMENT_STORAGESEGMENTID_GENERATOR", sequenceName="STORAGE_SEGMENT_SEQ", allocationSize=1)

	@GeneratedValue(strategy=GenerationType.SEQUENCE, generator="STORAGE_SEGMENT_STORAGESEGMENTID_GENERATOR")

	@Column(name="STORAGE_SEGMENT_ID", unique=true, nullable=false, precision=9)

	private long storageSegmentId;



	@Column(name="IS_ACTIVE", nullable=false, length=1)

	private String isActive;



	@Column(name="IS_FULL", nullable=false, length=1)

	private String isFull;



	@Column(name="SYSTEM_PATH", nullable=false, length=100)

	private String systemPath;



    public StorageSegment() {

    }



	public long getStorageSegmentId() {

		return this.storageSegmentId;

	}



	public void setStorageSegmentId(long storageSegmentId) {

		this.storageSegmentId = storageSegmentId;

	}



	public String getIsActive() {

		return this.isActive;

	}



	public void setIsActive(String isActive) {

		this.isActive = isActive;

	}



	public String getIsFull() {

		return this.isFull;

	}



	public void setIsFull(String isFull) {

		this.isFull = isFull;

	}



	public String getSystemPath() {

		return this.systemPath;

	}



	public void setSystemPath(String systemPath) {

		this.systemPath = systemPath;

	}



}