package gov.va.cem.docstorage.model;

import java.io.Serializable;
import javax.persistence.*;

/**
 * The persistent class for the DOC_CATALOG database table.
 * 
 */
@Entity
@Table(name="DOC_CATALOG")
public class DocCatalog implements Serializable {
	private static final long serialVersionUID = 1L;

	@Id
	@SequenceGenerator(name="DOC_CATALOG_DOCCATALOGID_GENERATOR", sequenceName="DOC_CATALOG_SEQ", allocationSize=1)
	@GeneratedValue(strategy=GenerationType.SEQUENCE, generator="DOC_CATALOG_DOCCATALOGID_GENERATOR")
	@Column(name="DOC_CATALOG_ID", unique=true, nullable=false, precision=9)
	private long docCatalogId;

	@Column(name="DIGEST_SHA1", nullable=false, length=32)
	private String digestSha1;

	@Column(name="DOCUMENT_PATH", nullable=false, length=253)
	private String documentPath;

	@Column(name="FILE_EXT", length=30)
	private String fileExt;

	@Column(nullable=false, length=100)
	private String filename;

	//uni-directional many-to-one association to StorageSegment
    @ManyToOne
	@JoinColumn(name="STORAGE_SEGMENT_ID", nullable=false)
	private StorageSegment storageSegment;

	//uni-directional many-to-one association to SystemAccount
    @ManyToOne
	@JoinColumn(name="SYSTEM_ACCOUNT_ID", nullable=false)
	private SystemAccount systemAccount;

    public DocCatalog() {
    }

	public long getDocCatalogId() {
		return this.docCatalogId;
	}

	public void setDocCatalogId(long docCatalogId) {
		this.docCatalogId = docCatalogId;
	}

	public String getDigestSha1() {
		return this.digestSha1;
	}

	public void setDigestSha1(String digestSha1) {
		this.digestSha1 = digestSha1;
	}

	public String getDocumentPath() {
		return this.documentPath;
	}

	public void setDocumentPath(String documentPath) {
		this.documentPath = documentPath;
	}

	public String getFileExt() {
		return this.fileExt;
	}

	public void setFileExt(String fileExt) {
		this.fileExt = fileExt;
	}

	public String getFilename() {
		return this.filename;
	}

	public void setFilename(String filename) {
		this.filename = filename;
	}

	public StorageSegment getStorageSegment() {
		return this.storageSegment;
	}

	public void setStorageSegment(StorageSegment storageSegment) {
		this.storageSegment = storageSegment;
	}
	
	public SystemAccount getSystemAccount() {
		return this.systemAccount;
	}

	public void setSystemAccount(SystemAccount systemAccount) {
		this.systemAccount = systemAccount;
	}
	
}