package gov.va.fnod.util;
/**
 * The FileDeleteException is intended be thrown anytime an attempt to delete
 * a File (or directory) is unsuccessful as indicated by a return value of 
 * false from File.delete.
 */
public class FileDeleteException extends RuntimeException {

  	private static final long serialVersionUID = 1L;

	/**
     * Provides filename of file could not be deleted.
     * @param filename contains absolute path of file 
     */
    public FileDeleteException(String filename) {
        super("Unable to delete:" + filename);
    }
    
}
