package gov.va.fnod.util;

/**
 * This is a convenience class, its methods are intended for reuse in the
 * implementation of equals and hashCode methods.
 */
public class EqualsHelper {
	/**
	 * This method is intended to be used inside of an object equals method and
	 * handles the case of null == null which returns true.
	 * <p />
	 * This implementation eliminates the repeated code:<br>
	 * &nbsp;&nbsp;&nbsp;(a == null && b == null) || (a != null && a.equals(b))
	 * 
	 * @param <E>
	 *            forces both parameters to be of the same type
	 * @param a
	 *            first value
	 * @param b
	 *            second value
	 * @return true if equals else false
	 */
	public static <E> boolean objectsEqual(E a, E b) {
		boolean retval = (a == null && b == null) || (a != null && a.equals(b));
		return retval;
	}

	/**
	 * Compute hashCode by summing returned values of hashCode from each object.
	 * Null objects will contribute the value 0;
	 * 
	 * @param values
	 *            An array of objects
	 * @return sum of hashCodes from objects
	 */
	public static int hashCode(Object... values) {
		int retval = 0;
		for (Object value : values) {
			retval += value == null ? 0 : value.hashCode();
		}
		return retval;
	}

	/**
	 * Class is meant to be used thru its static interface.
	 */
	private EqualsHelper() {
		super();
	}
}
