package gov.va.fnod.pl;

import gov.va.fnod.be.ConfigEntity;
import gov.va.fnod.bl.ProcessManager;

import org.apache.log4j.Logger;

/**
 * The Main class for FNOD Data Load process
 */
public class DataLoad {

	private static Logger log = Logger.getLogger(DataLoad.class);

	/**
	 * The no-arg constructor is made private to force use of class via the
	 * classes static interface.
	 */
	private DataLoad() {

	}

	/**
	 * This method is the single public system interface for FNOD Data Load
	 * process.
	 * 
	 * @param args
	 * command line arguments
	 */
	public static void main(String[] args) {
		int status = 0;
		try {
			log.debug("Program started.");
			System.out.println(args[0] + " " + args[1]);
			log.debug(args[0] + " " + args[1]);
			System.out.println("Working...");	
			ConfigEntity config = ConfigManager.parse(args);
			log.debug("Working..." );
			new ProcessManager(config.getReportConfigs(),
					config.getConnectionParams()).run();
			System.out.println(".....Done");
			log.debug(".....Done");
			log.debug("Program ended normally.");
		} catch (Exception e) {
			log.error("Error ended with unhandled exception", e);
			status = -1;
		}
		System.exit(status);
	}
	
	
}
