package gov.va.fnod.pl;



import gov.va.fnod.be.ConfigEntity;

import gov.va.fnod.be.ReportConfigEntity;

import gov.va.fnod.be.SourceReportType;

import gov.va.fnod.exceptions.ConfigurationException;

import gov.va.fnod.soa_common.model.ServiceConnectionParams;



import java.io.File;

import java.io.IOException;

import java.util.HashMap;



import javax.xml.parsers.ParserConfigurationException;

import javax.xml.parsers.SAXParser;

import javax.xml.parsers.SAXParserFactory;



import org.xml.sax.Attributes;

import org.xml.sax.SAXException;

import org.xml.sax.helpers.DefaultHandler;



/**

 * This class is responsible for parsing configuration xml.

 */

public class ConfigXmlParser extends DefaultHandler {



	private StringBuilder curText = new StringBuilder();

	private ConfigEntity config;



	/**

	 * The no-arg constructor is made private to force use of the class via its

	 * static interface.

	 */

	private ConfigXmlParser() {



	}



	/**

	 * Parses xml file, returning ConfigEntity.

	 * @param xmlFilename path to xml configuration file

	 * @return ConfigEntity populated with data from xml configuration file

	 */

	public static ConfigEntity parse(String xmlFilename) {

		SAXParserFactory factory = SAXParserFactory.newInstance();

		SAXParser saxParser;

		try {

			saxParser = factory.newSAXParser();

		} catch (ParserConfigurationException e) {

			throw new ConfigurationException("Cannot get SAXParserFactory ", e);

		} catch (SAXException e) {

			throw new ConfigurationException("Cannot get SAXParserFactory ", e);

		}

		ConfigXmlParser xmlHandler = new ConfigXmlParser();

		try {

			saxParser.parse(new File(xmlFilename), xmlHandler);

		} catch (SAXException e) {

			throw new ConfigurationException("Failed parsing config file ", e);

		} catch (IOException e) {

			throw new ConfigurationException("Failed parsing config file ", e);

		}

		return xmlHandler.config;

	}



	/**

	 * Intitializes configuration.

	 * @throws SAXException

	 */

	@Override

	public void startDocument() throws SAXException {

		curText.setLength(0);

	}



	/**

	 * This section is used primarily for processing values out of attributes.

	 * Additionally, this section may be used to initialize values needed by the

	 * endElement method.

	 * 

	 * @param uri

	 *            The Namespace URI, or the empty string if the element has no

	 *            Namespace URI or if Namespace processing is not being

	 *            performed.

	 * @param localName

	 *            The local name (without prefix), or the empty string if

	 *            Namespace processing is not being performed.

	 * @param qName

	 *            The qualified name (with prefix), or the empty string if

	 *            qualified names are not available.

	 * @param attributes

	 *            The attributes attached to the element. If there are no

	 *            attributes, it shall be an empty Attributes object.

	 * @exception org.xml.sax.SAXException

	 *                Any SAX exception, possibly wrapping another exception.

	 * @see DefaultHandler#startElement

	 */

	@Override

	public void startElement(String uri, String localName, String qName,

			Attributes attributes) throws SAXException {



		curText.setLength(0);



		if ("config".equalsIgnoreCase(qName)) {

			config = new ConfigEntity();

		} else if ("report".equalsIgnoreCase(qName)) {

			if (config.getReportConfigs() == null

					|| config.getReportConfigs().isEmpty()) {

				config.setReportConfigs(new HashMap<SourceReportType, ReportConfigEntity>());

			}

			(config.getReportConfigs()).put(

					SourceReportType.getEnum(attributes

							.getValue("sourceReportType")),

					new ReportConfigEntity(SourceReportType.getEnum(attributes

							.getValue("sourceReportType")), attributes

							.getValue("filenamePattern"), attributes

							.getValue("inputDirPath"), attributes

							.getValue("workingDirPath"), attributes

							.getValue("completedDirPath")));

		} else if ("service".equalsIgnoreCase(qName)) {

			config.setConnectionParams(new ServiceConnectionParams(attributes

					.getValue("endpoint"), attributes.getValue("username"),

					attributes.getValue("password"),null));

		}

	}



	/**

	 * This collects all the text for an element. Since the sax parser is a

	 * block reader, there is no guarantee that all data for an element will be

	 * available at one time. This method collects the text for use in the

	 * endElement method where the whole text block will be available.

	 * 

	 * @param ch

	 *            The characters.

	 * @param start

	 *            The start position in the character array.

	 * @param length

	 *            The number of characters to use from the character array.

	 * @exception org.xml.sax.SAXException

	 *                Any SAX exception, possibly wrapping another exception.

	 * @see DefaultHandler#characters

	 */

	@Override

	public void characters(char[] ch, int start, int length)

			throws SAXException {

		curText.append(ch, start, length);

	}

}