package gov.va.fnod.pl;

import gov.va.fnod.be.ConfigEntity;
import gov.va.fnod.exceptions.ConfigurationException;

/**
 * This class is responsible for controlling the process of gathering
 * configuration parameters from the command line and configuration file.
 */
public class ConfigManager {

	/**
	 * The no-arg constructor is made private to ensure all usage of this class
	 * is done through its static interface.
	 */
	private ConfigManager() {
	}

	/**
	 * Controls the process of building a ConfigEntity from a combination of
	 * command line arguments and a configuration file.
	 * @param args command line arguments
	 * @return assembled ConfigEntity
	 */
	public static ConfigEntity parse(String... args) {

		ConfigEntity cmdLine = ConfigCmdLineParser.parse(args);
		ConfigEntity xml = ConfigXmlParser.parse(cmdLine.getXmlFilename());
		if (xml == null) {
			throw new ConfigurationException("no configuration loaded from xml");
		}
		// Preserve the path to the xml config file
		xml.setXmlFilename(cmdLine.getXmlFilename());
		return xml;
	}
}