package gov.va.fnod.pl;

import gov.va.fnod.be.ConfigEntity;
import gov.va.fnod.exceptions.ConfigurationException;
import jargs.gnu.CmdLineParser;
import jargs.gnu.CmdLineParser.IllegalOptionValueException;
import jargs.gnu.CmdLineParser.UnknownOptionException;

import java.io.File;

/**
 * This class is responsible for parsing command line arguments.
 */
public class ConfigCmdLineParser {

	/**
	 * The no-arg constructor has been made private since this class is expected
	 * to be used through its static interface.
	 */
	private ConfigCmdLineParser() {
	}

	/**
	 * Parses command line arguments into a ConfigEntity.
	 * @param args - command line arguments
	 * @return ConfigEntity built from command line arguments
	 */
	public static ConfigEntity parse(String[] args) {

		CmdLineParser parser = new CmdLineParser();
		CmdLineParser.Option optConfigFile;
		optConfigFile = parser.addStringOption('c', "config");

		try {
			parser.parse(args);
			if (parser.getRemainingArgs().length != 0) {
				throw new ConfigurationException(
						"Unexpected values on command line\n" + showUsage());
			}
			String configPath = (String) parser.getOptionValue(optConfigFile);
			if (configPath == null) {
				throw new ConfigurationException("[-c|--config] is required.\n"
						+ showUsage());
			}
			File xmlFile = new File(configPath);
			if (xmlFile.isFile()) {
				ConfigEntity config = new ConfigEntity();
				config.setXmlFilename(configPath);
				return config;
			} else {
				throw new ConfigurationException("config file not found\n"
						+ showUsage());
			}
		} catch (IllegalOptionValueException e) {
			throw new ConfigurationException("command line parsing error\n"
					+ showUsage(), e);
		} catch (UnknownOptionException e) {
			throw new ConfigurationException("unknown option on command line\n"
					+ showUsage(), e);
		}
	}

	/**
	 * Produces a usage message for command line arguments.
	 * @return usage message.
	 */
	private static String showUsage() {
		return "usage: cmd [-c|--config] configFilePath";
	}
}