package gov.va.fnod.exceptions;

/**
 * This exception should be thrown anytime an exception can be identified as
 * being caused by the values provided during system configuration.
 */
public class ConfigurationException extends RuntimeException {

	private static final long serialVersionUID = 1L;

	/**
	 * Constructor allowing for chaining of causes.
	 * @param cause what caused this exception to be created
	 */
	public ConfigurationException(Throwable cause) {
		super(cause);
	}

	/**
	 * Constructor allowing for a message to be associated with exception and
	 * allowing for chaining of causes.
	 * @param message text describing exception
	 * @param cause what caused this exception to be created
	 */
	public ConfigurationException(String message, Throwable cause) {
		super(message, cause);
	}

	/**
	 * Constructor allowing for a message to be associated with exception.
	 * @param message text describing exception
	 */
	public ConfigurationException(String message) {
		super(message);
	}

	/**
	 * Simple no-arg constructor.
	 */
	public ConfigurationException() {
		super();
	}
}