package gov.va.fnod.bl;

import gov.va.cem.common.csvfile.CsvDelimiters;
import gov.va.fnod.be.SourceReportType;

/**
 * RecordSplitterFactory - provides the headerLength, footerLength, recordLength
 * and number of records per page based on the Source Report type
 */
public class RecordSplitterFactory {
	
	/**
	 * Returns the RecordSplittable instance based on the Source Report type
	 * @param sourceReportType
	 * @return
	 */
	public static RecordSplittable getInstance(SourceReportType sourceReportType) {
		switch (sourceReportType) {
		case AMAS_FNOD:
			return new RecordSplitter(2, 5, 7, 8);
		case AMAS_FNOD_SPOUSE:
			return new RecordSplitter(2, 6, 11, 5);
		case BOSS_FNOD:
			return new RecordSplitter(3, 5, 11, 5);
		case BOSS_FNOD_SPOUSE:
			return new RecordSplitter(2, 1, 15, 4, 2, 15, 15, 3);
		case ANC_FNOD:
			return new RecordSplitter(3, 5, 11, 5);	
		case ANC_FNOD2:
			return new RecordSplitter(3, 5, 11, 5);	
		case ANC_FNOD_SPOUSE:
			return new RecordSplitter(2, 1, 15, 4);	
		case ANC_FNOD_SPOUSE2:
			return new RecordSplitter(2, 1, 15, 4);	
		case INSURANCE_REPORT:
			return new CvsRecordSplitter(CsvDelimiters.Field.Pipe);			
		case PRUDENTIAL_INSURANCE:  // ok, checked 2/18/2015
			return new CvsRecordSplitter(CsvDelimiters.Field.Comma);
		default:
			throw new IllegalArgumentException(
					"IllegalArgumentException sourceReportType: "
							+ sourceReportType);
		}
	}

}