package gov.va.fnod.bl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

/**
 * This class is responsible for splitting the Reports into records
 */
public class RecordSplitter implements RecordSplittable {
	
	/**
	 * The constructor takes the headerLength, footerLength, recordLength and
	 * number of records
	 * 
	 * @param headerLength
	 * @param footerLength
	 * @param recordLength
	 * @param numOfRecordsPerPage
	 */
	public RecordSplitter(int headerLength, int footerLength, int recordLength,
			int numOfRecordsPerPage) {
		this.headerLength = headerLength;
		this.footerLength = footerLength;
		this.recordLength = recordLength;
		this.numOfRecordsPerPage = numOfRecordsPerPage;
	}
	
	
	
	public RecordSplitter(int headerLength, int footerLength, int recordLength,
			int numOfRecordsPerPage, int headerLength2, int footerLength2,
			int recordLength2, int numOfRecordsPerPage2) {
		super();
		this.headerLength = headerLength;
		this.footerLength = footerLength;
		this.recordLength = recordLength;
		this.numOfRecordsPerPage = numOfRecordsPerPage;
		this.headerLength2 = headerLength2;
		this.footerLength2 = footerLength2;
		this.recordLength2 = recordLength2;
		this.numOfRecordsPerPage2 = numOfRecordsPerPage2;
	}



	private int headerLength;
	private int footerLength;
	private int recordLength;
	private int numOfRecordsPerPage;
	private int headerLength2;
	private int footerLength2;
	private int recordLength2;
	private int numOfRecordsPerPage2;
	
	/**
	 * Splits the Report into records and writes to the disk
	 */
	@Override
	public void splitRecords(Reader reader, SplitterCallbackInterface splitterCallback) {
		if(reader == null) {
			throw new IllegalArgumentException("reader should not be null value");
		}
		String strLine = null; 
		StringBuilder recordDateStr = null;
		int count = 1;//line count
		int recordCnt = 0;//number of records
		int pageCnt = 1;//page number
		BufferedReader br = (BufferedReader) reader;
		StringBuilder recordString = null;
		FNODHelper helper = new FNODHelper();
		
		try {
			while((strLine = br.readLine()) != null) {
				if(count > (headerLength + (recordLength * numOfRecordsPerPage))) {//skip the footer
					//reached end of the page - reset count, record count and increment the page count
					if(count == headerLength + (recordLength * numOfRecordsPerPage) + footerLength) {						
						count = 0;
						recordCnt = 0;
						pageCnt++;			
						recordDateStr = null;
					}
					count++;//increment the count till the end of page is reached
					continue;
				}
				//get the date string from the header
				if (count <= headerLength) {
					if (strLine.length() != 0) {
						if(recordDateStr == null) {
							recordDateStr = new StringBuilder();			
						}
						recordDateStr.append(strLine);						
					}
				}
				if(count == headerLength + (recordLength * recordCnt) + 1) {//identify the beginning of the new record
					recordCnt++;//increment the record count
					recordString = new StringBuilder();					
				}
				//append to the  recordString till the end of the record is reached
				if(count > headerLength && count <= (headerLength + (recordLength * recordCnt))) {
					if(!strLine.isEmpty()) {
						if(count != (headerLength + (recordLength * recordCnt))) {
							recordString.append(strLine).append("\r\n");
						}						
					}
					//write to the disk once the end of the record is reached
					if(count == headerLength + (recordLength * recordCnt)) {
						if(recordString.length() != 0) {
							recordString.append(helper.getReportDate(recordDateStr));
							splitterCallback.writeRecord(recordString.toString(), pageCnt+"_"+recordCnt);
						}
					}
				}			
				count++;//increment the count
			}
			br.close();
			reader.close();
		} catch (IOException e) {
			try {
				br.close();
				reader.close();
			} catch (IOException e1) {
				throw new RuntimeException("Failed to close the reader");
			}
			throw new RuntimeException("Failed to split the report");
		} finally {
			try {
				br.close();
				reader.close();
			} catch (IOException e1) {
				throw new RuntimeException("Failed to close the reader");
			}
		}
	}

	@Override
	public void splitBossSpouseRecords(Reader reader, SplitterCallbackInterface splitterCallback) {
		if(reader == null) {
			throw new IllegalArgumentException("reader should not be null value");
		}
		String strLine = null; 
		StringBuilder recordDateStr = null;
		int count = 1;//line count
		int recordCnt = 0;//number of records
		int pageCnt = 1;//page number
		BufferedReader br = (BufferedReader) reader;
		StringBuilder recordString = null;
		FNODHelper helper = new FNODHelper();
		
		try {
			while((strLine = br.readLine()) != null) {
				if( (pageCnt % 2) == 0 ) { // even pages
					if(count > (headerLength2 + (recordLength2 * numOfRecordsPerPage2))) {//skip the footer
						//reached end of the page - reset count, record count and increment the page count
						if(count == headerLength2 + (recordLength2 * numOfRecordsPerPage2) + footerLength2) {						
							count = 0;
							recordCnt = 0;
							pageCnt++;			
							recordDateStr = null;
						}
						count++;//increment the count till the end of page is reached
						continue;
					}
					//get the date string from the header
					if (count <= headerLength2) {
						if (strLine.length() != 0) {
							if(recordDateStr == null) {
								recordDateStr = new StringBuilder();			
							}
							recordDateStr.append(strLine);						
						}
					}
					if(count == headerLength2 + (recordLength2 * recordCnt) + 1) {//identify the beginning of the new record
						recordCnt++;//increment the record count
						recordString = new StringBuilder();					
					}
					//append to the  recordString till the end of the record is reached
					if(count > headerLength2 && count <= (headerLength2 + (recordLength2 * recordCnt))) {
						if(!strLine.isEmpty()) {
							if(count != (headerLength2 + (recordLength2 * recordCnt))) {
								recordString.append(strLine).append("\r\n");
							}						
						}
						//write to the disk once the end of the record is reached
						if(count == headerLength2 + (recordLength2 * recordCnt)) {
							if(recordString.length() != 0) {
								recordString.append(helper.getReportDate(recordDateStr));
								splitterCallback.writeRecord(recordString.toString(), pageCnt+"_"+recordCnt);
							}
						}
					}			
					
					
				}else { 
					if(count > (headerLength + (recordLength * numOfRecordsPerPage))) {//skip the footer
						//reached end of the page - reset count, record count and increment the page count
						if(count == headerLength + (recordLength * numOfRecordsPerPage) + footerLength) {						
							count = 0;
							recordCnt = 0;
							pageCnt++;			
							recordDateStr = null;
						}
						count++;//increment the count till the end of page is reached
						continue;
					}
					
					//get the date string from the header
					if (count <= headerLength) {
						if (strLine.length() != 0) {
							if(recordDateStr == null) {
								recordDateStr = new StringBuilder();			
							}
							recordDateStr.append(strLine);						
						}
					}
					if(count == headerLength + (recordLength * recordCnt) + 1) {//identify the beginning of the new record
						recordCnt++;//increment the record count
						recordString = new StringBuilder();					
					}
					//append to the  recordString till the end of the record is reached
					if(count > headerLength && count <= (headerLength + (recordLength * recordCnt))) {
						if(!strLine.isEmpty()) {
							if(count != (headerLength + (recordLength * recordCnt))) {
								recordString.append(strLine).append("\r\n");
							}						
						}
						//write to the disk once the end of the record is reached
						if(count == headerLength + (recordLength * recordCnt)) {
							if(recordString.length() != 0) {
								recordString.append(helper.getReportDate(recordDateStr));
								splitterCallback.writeRecord(recordString.toString(), pageCnt+"_"+recordCnt);
							}
						}
					}			
				}
		
				count++;//increment the count
			}
			br.close();
			reader.close();
		} catch (IOException e) {
			try {
				br.close();
				reader.close();
			} catch (IOException e1) {
				throw new RuntimeException("Failed to close the reader");
			}
			throw new RuntimeException("Failed to split the report");
		} finally {
			try {
				br.close();
				reader.close();
			} catch (IOException e1) {
				throw new RuntimeException("Failed to close the reader");
			}
		}
		
	}
	
	
	public int getHeaderLength() {
		return headerLength;
	}

	public void setHeaderLength(int headerLength) {
		this.headerLength = headerLength;
	}

	public int getFooterLength() {
		return footerLength;
	}

	public void setFooterLength(int footerLength) {
		this.footerLength = footerLength;
	}

	public int getRecordLength() {
		return recordLength;
	}

	public void setRecordLength(int recordLength) {
		this.recordLength = recordLength;
	}

	public int getNumOfRecordsPerPage() {
		return numOfRecordsPerPage;
	}

	public void setNumOfRecordsPerPage(int numOfRecordsPerPage) {
		this.numOfRecordsPerPage = numOfRecordsPerPage;
	}

	public int getHeaderLength2() {
		return headerLength2;
	}

	public void setHeaderLength2(int headerLength2) {
		this.headerLength2 = headerLength2;
	}

	public int getFooterLength2() {
		return footerLength2;
	}

	public void setFooterLength2(int footerLength2) {
		this.footerLength2 = footerLength2;
	}

	public int getRecordLength2() {
		return recordLength2;
	}

	public void setRecordLength2(int recordLength2) {
		this.recordLength2 = recordLength2;
	}

	public int getNumOfRecordsPerPage2() {
		return numOfRecordsPerPage2;
	}

	public void setNumOfRecordsPerPage2(int numOfRecordsPerPage2) {
		this.numOfRecordsPerPage2 = numOfRecordsPerPage2;
	}

	

}