package gov.va.fnod.bl;

import gov.va.fnod.be.SourceReportType;

import java.util.ArrayList;
import java.util.List;

/**
 * RecordParserFactory - provides the list of FeildDef's based on the Source Report type
 *
 */
public class RecordParserFactory {
	
	static List<List<FieldDef>> amas = new ArrayList<List<FieldDef>>();//contains list of AMAS FieldDef's 
	static List<List<FieldDef>> boss = new ArrayList<List<FieldDef>>();//contains list of BOSS FieldDef's
	static List<List<FieldDef>> bossSpouse = new ArrayList<List<FieldDef>>();//contains list of BOSS_SPOUSE FieldDef's 
	static List<List<FieldDef>> fnodSpouse = new ArrayList<List<FieldDef>>();//contains list of FNOD_SPOUSE FieldDef's
	static List<FieldDef> recordDateLine = new ArrayList<FieldDef>();//line containing the record date
	static List<FieldDef> recordDateIndex = new ArrayList<FieldDef>();
	
	//populate the list of FieldDef's based on the Source Report Type
	static {
		List<FieldDef> line;

		line = new ArrayList<FieldDef>();
		line.add(new FieldDef(FieldType.VETERAN_LAST_NAME, 0, 25, null));
		line.add(new FieldDef(FieldType.VETERAN_FIRST_NAME, 30, 45, null));
		line.add(new FieldDef(FieldType.VETERAN_MIDDLE_NAME, 55, 70, null));
		line.add(new FieldDef(FieldType.VETERAN_SUFFIX_NAME, 75, 78, null));

		amas.add(null);
		amas.add(line);

		boss.add(null);
		boss.add(line);
		
		bossSpouse.add(null);
		bossSpouse.add(line);

		line = new ArrayList<FieldDef>();
		line.add(new FieldDef(FieldType.VETERAN_SOCIAL_SECURITY_NUM, 0, 11,
				null));
		line.add(new FieldDef(FieldType.MILITARY_SERVICE_NUM, 15, 25, null));
		line.add(new FieldDef(FieldType.VETERAN_BIRTH_DT, 30, 40,
				FNODConstants.DATE_FORMAT_MMDDYYYY));
		line.add(new FieldDef(FieldType.VETERAN_DEATH_DT, 45, 55,
				FNODConstants.DATE_FORMAT_MMDDYYYY));
		line.add(new FieldDef(FieldType.BRANCH_OF_SERVICE_CD, 60, 62, null));
		line.add(new FieldDef(FieldType.RANK_CD, 65, 85, null));

		amas.add(null);
		amas.add(line);

		boss.add(null);
		boss.add(line);
		
		bossSpouse.add(null);
		bossSpouse.add(line);

		line = new ArrayList<FieldDef>();
		line.add(new FieldDef(FieldType.ENTERED_ON_ACTIVE_DUTY_DT, 0, 10,
				FNODConstants.DATE_FORMAT_MMDDYYYY));
		line.add(new FieldDef(FieldType.RELEASED_FROM_ACTIVE_DUTY_DT, 15, 29,
				FNODConstants.DATE_FORMAT_MMDDYYYY));
		line.add(new FieldDef(FieldType.WAR_PERIOD_CD, 30, 34, null));
		line.add(new FieldDef(FieldType.VETERAN_ID, 45, 54, null));
		line.add(new FieldDef(FieldType.SOURCE_USER_ID, 60, 68, null));

		amas.add(null);
		amas.add(line);
		
		line = new ArrayList<FieldDef>();
		line.add(new FieldDef(FieldType.ENTERED_ON_ACTIVE_DUTY_DT, 0, 14,
				FNODConstants.DATE_FORMAT_MMMMDDYYYY));
		line.add(new FieldDef(FieldType.RELEASED_FROM_ACTIVE_DUTY_DT, 15, 29,
				FNODConstants.DATE_FORMAT_MMMMDDYYYY));
		line.add(new FieldDef(FieldType.WAR_PERIOD_CD, 30, 44, null));
		line.add(new FieldDef(FieldType.VETERAN_CLAIM_NUM, 45, 54, null));
		line.add(new FieldDef(FieldType.VETERAN_ALIAS_LAST_NAME, 54, 79, null));

		boss.add(null);
		boss.add(line);
		
		bossSpouse.add(null);
		bossSpouse.add(line);

		line = new ArrayList<FieldDef>();
		line.add(new FieldDef(FieldType.VETERAN_DECEDENT_ID, 0, 9, null));
		line.add(new FieldDef(FieldType.VETERAN_RECORD_OF_INTERMENT_DT, 15, 25,
				FNODConstants.DATE_FORMAT_MMDDYYYY));
		line.add(new FieldDef(FieldType.CEMETERY_NAME, 30, 64, null)); // max 50 in db, but not files
		line.add(new FieldDef(FieldType.CEMETERY_TYPE, 65, 66, null));
		line.add(new FieldDef(FieldType.CEMETERY_NUM, 70, 73, null));

		boss.add(null);
		boss.add(line);
		
		line = new ArrayList<FieldDef>();
		line.add(new FieldDef(FieldType.VETERAN_DECEDENT_ID, 0, 9, null));
		line.add(new FieldDef(FieldType.VETERAN_RECORD_OF_INTERMENT_DT, 15, 25,
				FNODConstants.DATE_FORMAT_MMDDYYYY));
		line.add(new FieldDef(FieldType.CEMETERY_NAME, 30, 64, null));
		line.add(new FieldDef(FieldType.CEMETERY_TYPE, 65, 66, null));
		line.add(new FieldDef(FieldType.CEMETERY_NUM, 75, 78, null));

		bossSpouse.add(null);
		bossSpouse.add(line);

		line = new ArrayList<FieldDef>();
		line.add(new FieldDef(FieldType.VETERAN_HOME_OF_RECORD_CITY, 0, 29,
				null)); // max 30 in db, but not in file
		line.add(new FieldDef(FieldType.VETERAN_HOME_OF_RECORD_STATE, 30, 50,
				null));

		boss.add(null);
		boss.add(line);
		
		bossSpouse.add(null);
		bossSpouse.add(line);
		
		line = new ArrayList<FieldDef>();
		line.add(new FieldDef(FieldType.SPOUSE_LAST_NAME, 0, 25, null));
		line.add(new FieldDef(FieldType.SPOUSE_FIRST_NAME, 30, 45, null));
		line.add(new FieldDef(FieldType.SPOUSE_MIDDLE_NAME, 55, 70, null));
		line.add(new FieldDef(FieldType.SPOUSE_DECEDENT_ID, 72, 81, null));

		fnodSpouse.add(null);
		fnodSpouse.add(line);

		line = new ArrayList<FieldDef>();
		line.add(new FieldDef(FieldType.SPOUSE_BIRTH_DT, 0, 10,
				FNODConstants.DATE_FORMAT_MMDDYYYY));
		line.add(new FieldDef(FieldType.SPOUSE_DEATH_DT, 15, 25,
				FNODConstants.DATE_FORMAT_MMDDYYYY));
		line.add(new FieldDef(FieldType.SPOUSE_RECORD_OF_INTERMENT_DT, 30, 40,
				FNODConstants.DATE_FORMAT_MMDDYYYY));

		fnodSpouse.add(null);
		fnodSpouse.add(line);
				
		recordDateLine .add(new FieldDef(FieldType.REPORTED_DT, 6, 16, FNODConstants.DATE_FORMAT_MMDDYYYY));
	}
	
	/**
	 * Returns the RecordParsable instance based on the Source Report type
	 * @param sourceReportType
	 * @return
	 */
	public static RecordParsable getInstance(SourceReportType sourceReportType) {
		switch (sourceReportType) {
		
		case AMAS_FNOD:
			return amasFnodFields();
		case AMAS_FNOD_SPOUSE:
			return amasFnodSpouseFields();
			
		case BOSS_FNOD:
			return bossFnodFields();
		case BOSS_FNOD_SPOUSE:
			return bossFnodSpouseFields();
			
		case ANC_FNOD:
		case ANC_FNOD2:
			return bossFnodFields();
		
		case ANC_FNOD_SPOUSE:
		case ANC_FNOD_SPOUSE2:
			return bossFnodSpouseFields();
			
		case INSURANCE_REPORT:
			return new InsuranceRecordParser();
			
		case PRUDENTIAL_INSURANCE:  // ok, checked 2/18/2015
			return new PrudentialRecordParser();			// ok, checked 2/18/2015		
			
		default:
			throw new IllegalArgumentException(
					"IllegalArgumentException sourceReportType: " + sourceReportType);
		}
	}
	
	/**
	 * Returns the RecordParsable instance for AMAS_FNOD
	 * @return
	 */
	private static RecordParsable amasFnodFields() {
		List<List<FieldDef>> fieldDefs = new ArrayList<List<FieldDef>>();
		fieldDefs.addAll(amas);
		fieldDefs.add(recordDateLine);
		return new RecordParser(fieldDefs);
	}
	
	/**
	 * Returns the RecordParsable instance for AMAS_FNOD_SPOUSE
	 * @return
	 */
	private static RecordParsable amasFnodSpouseFields() {
		List<List<FieldDef>> fieldDefs = new ArrayList<List<FieldDef>>();
		fieldDefs.addAll(amas);
		fieldDefs.addAll(fnodSpouse);
		fieldDefs.add(recordDateLine);
		return new RecordParser(fieldDefs);
	}
	
	/**
	 * Returns the RecordParsable instance for BOSS_FNOD
	 * @return
	 */
	private static RecordParsable bossFnodFields() {
		List<List<FieldDef>> fieldDefs = new ArrayList<List<FieldDef>>();
		fieldDefs.addAll(boss);
		fieldDefs.add(recordDateLine);
		return new RecordParser(fieldDefs);
	}
	
	/**
	 * Returns the RecordParsable instance for BOSS_FNOD_SPOUSE
	 * @return
	 */
	private static RecordParsable bossFnodSpouseFields() {
		List<List<FieldDef>> fieldDefs = new ArrayList<List<FieldDef>>();
		fieldDefs.addAll(bossSpouse);
		fieldDefs.addAll(fnodSpouse);
		fieldDefs.add(recordDateLine);
		return new RecordParser(fieldDefs);
	}
	
}