package gov.va.fnod.bl;

import gov.va.fnod.soa_common.model.fnod.FnodCase;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/**
 * This class is responsible for parsing the record 
 */
public class RecordParser implements RecordParsable {
	
	/**
	 * The constructor takes the list of field def's
	 * @param fieldDefs
	 */
	public RecordParser(List<List<FieldDef>> fieldDefs) {
		this.fieldDefs = fieldDefs;
	}
	
	private static Logger log = Logger.getLogger(RecordParser.class);
	
	private List<List<FieldDef>> fieldDefs;
	
	/**
	 * parses the record
	 */
	@Override
	public FnodCase parseRecord(Reader reader) {
		log.debug("In parseRecord");
		if (reader == null) {
			throw new IllegalArgumentException("reader should not be null value");
		}
		String strLine = null;
		Map<Enum<FieldType>, Object> caseDataValues = new HashMap<Enum<FieldType>, Object>();
		BufferedReader br = (BufferedReader) reader;
		FNODHelper helper = new FNODHelper();
		String fieldValue = null;
		
		try {
			//for each line
			@SuppressWarnings("unused")
			int lineNum=0;
			for (List<FieldDef> line : fieldDefs) {
				lineNum++;
				while ((strLine = br.readLine()) != null) {
					if (!strLine.isEmpty()) {
						if (line != null) {
							//for each field
							for (FieldDef field : line) {
								// System.out.println("Parsing " + field.getFieldType().toString() + " line #" + lineNum + " at position " + field.getStartPos() + " to " + field.getEndPos() + " from the following line: \n" + strLine);
								// System.out.println(repeatChar(' ', field.getStartPos()) + '^' + repeatChar(' ', field.getEndPos() - field.getStartPos() - 1) + '^');
								
								strLine = StringUtils.rightPad(strLine, 85);// TODO temp hardcoded to 85
								//get the value of the field and put in the Map
								fieldValue = strLine.substring(field.getStartPos(), field.getEndPos());
								if(fieldValue != null && !fieldValue.trim().isEmpty()) {
									caseDataValues.put(field.getFieldType(), fieldValue.trim());	
								}
								//check to see if the field requires date formatting
								if (field.getDateFormat() != null && !field.getDateFormat().isEmpty()) {
									caseDataValues.put(field.getFieldType(), helper.formatDate((String)caseDataValues.get(field.getFieldType())));
								}
							}
							break;
						} else {
							break;
						}
					}
				}
			}
		} catch (IOException e) {
			try {
				br.close();
				reader.close();
			} catch (IOException e1) {
				throw new RuntimeException("Failed to close the reader");
			}
			throw new RuntimeException("Failed to parse the file");
		} finally {
			try {
				br.close();
				reader.close();
			} catch (IOException e1) {
				throw new RuntimeException("Failed to close the reader");
			}
		}
		return helper.getFnodCaseData(caseDataValues);
	}

	public List<List<FieldDef>> getFieldDefs() {
		return fieldDefs;
	}

	public void setFieldDefs(List<List<FieldDef>> fieldDefs) {
		this.fieldDefs = fieldDefs;
	}
	
	public String repeatChar(char toRepeat, int times) {
		char[] chars = new char[times];
		Arrays.fill(chars, toRepeat);
		return new String(chars);
	}
}