package gov.va.fnod.bl;



import gov.va.cem.common.csvfile.CsvDelimiters;
import gov.va.cem.common.csvfile.DataFileReader;
import gov.va.fnod.soa_common.model.fnod.CaseTypeCd;
import gov.va.fnod.soa_common.model.fnod.Fnod;
import gov.va.fnod.soa_common.model.fnod.FnodCase;
import gov.va.fnod.soa_common.model.fnod.Insurance;




import gov.va.fnod.soa_common.model.fnod.Person;
import gov.va.fnod.soa_common.model.fnod.PersonName;
import gov.va.fnod.soa_common.model.fnod.SourceSystemCd;
import gov.va.fnod.soa_common.model.fnod.Veteran;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;







import org.apache.log4j.Logger;



public class PrudentialRecordParser implements RecordParsable, PrudentialFields {

	

	private static Logger log = Logger.getLogger(PrudentialRecordParser.class);

	

	

	public PrudentialRecordParser() {

		super();

	}

	

	@Override

	public FnodCase parseRecord(Reader reader) {

		if (reader == null) {

			log.error("The reader was null was null from the parameter.");

			throw new IllegalArgumentException("The reader should not be a null value.");

		}

		BufferedReader br = (BufferedReader) reader;

		FnodCase fnodCase = new FnodCase();

		Insurance insurance = new Insurance();

		FNODHelper helper = new FNODHelper();
		String fn = "";
		String mn = "";
		String ln = "";

		try {

			DataFileReader dfr = new DataFileReader(br, CsvDelimiters.Field.Comma);

			while (dfr.next()) {

				
				fn = dfr.getValue(VET_FIRST_NAME);
				mn = dfr.getValue(VET_MIDDLE_INITIAL);
				ln = dfr.getValue(VET_LAST_NAME);
				String vetName = formatName(dfr.getValue(VET_FIRST_NAME), 

						                    dfr.getValue(VET_MIDDLE_INITIAL), 

						                    dfr.getValue(VET_LAST_NAME));

				

				insurance.setVeteranName(vetName);

				

				insurance.setDateOfBirth(dfr.getValue(DATE_OF_BIRTH));

				insurance.setDateOfDeath(dfr.getValue(DATE_OF_DEATH));

				

				insurance.setInsuranceFileNumber(dfr.getValue(CLAIM_ID));

				

				String ssn = dfr.getValue(SOCIAL_SECURITY_NUMBER);

				if ( ! isEmpty(ssn) ) {

					ssn = ssn.replace("-", "");

					insurance.setSocialSecurityNumber(ssn);	

				}								

	
				fnodCase.setInsurance(insurance);
				fnodCase.setReportedDate(helper.formatXMLGregorianCalendar(dfr.getValue(EXTRACT_DATE)));
				

			}

			
			fnodCase.setCaseTypeCd(CaseTypeCd.PRUDENTIAL_INSURANCE);// ok, checked 2/18/2015
			fnodCase.setSourceSystemCd(SourceSystemCd.PRUDENTIAL_INSURANCE); // ok, checked 2/18/2015
			
			// create veteran
			Veteran veteran = new Veteran();
			veteran.setServiceNumber(insurance.getServiceNumber());
			veteran.setClaimNumber(insurance.getInsuranceFileNumber());
			
			veteran.setPerson(new Person());
			PersonName pn = new PersonName() ;
			pn.setFirstName(fn);
			pn.setMiddleName(mn);
			pn.setLastName(ln);
			veteran.getPerson().setName(pn);
			veteran.getPerson().setSocialSecurityNumber(insurance.getSocialSecurityNumber());
			veteran.getPerson().setDateOfBirth(FNODHelper.formatXMLGregorianCalendar(insurance.getDateOfBirth()));
			veteran.getPerson().setDateOfDeath(FNODHelper.formatXMLGregorianCalendar(insurance.getDateOfDeath()));
			
			// set FNOD values
			fnodCase.setFnod(new Fnod());
			fnodCase.getFnod().setVeteran(veteran);
			

		} catch (IOException e) {

			log.error(e.getMessage(), e.fillInStackTrace());

			throw new RuntimeException("Failed to parse the record due to a serous failure.");

		} finally {

			try {

				br.close();

			} catch (IOException e) {

				log.error(e.getMessage(), e.fillInStackTrace());

				throw new RuntimeException("Failed to close the buffered reader.");

			}

		}

		return fnodCase;

	}



	private boolean isEmpty(String value) {

		return value == null || value.trim().isEmpty();

	}

	

	private String formatName(String firstName, String middleInitial, String lastName) {

		StringBuilder sb = new StringBuilder();

	

		if( ! isEmpty(firstName) ) {

			sb.append(firstName.trim());

		}

		

		if ( ! isEmpty(middleInitial) ) {

			if ( sb.length() > 0 ) {

				sb.append(" ");

			} 

			sb.append(middleInitial.trim());

		}

		

		if ( ! isEmpty(lastName) ) {

			if ( sb.length() > 0 ) {

				sb.append(" ");

			} 

			sb.append(lastName.trim());

		}

		

		return sb.toString();

	}



}

