package gov.va.fnod.bl;



import gov.va.cem.common.csvfile.CsvDelimiters;
import gov.va.cem.common.csvfile.DataFileReader;
import gov.va.fnod.soa_common.model.fnod.CaseTypeCd;
import gov.va.fnod.soa_common.model.fnod.Fnod;
import gov.va.fnod.soa_common.model.fnod.FnodCase;
import gov.va.fnod.soa_common.model.fnod.Insurance;
import gov.va.fnod.soa_common.model.fnod.Person;
import gov.va.fnod.soa_common.model.fnod.SourceSystemCd;
import gov.va.fnod.soa_common.model.fnod.Veteran;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

import org.apache.log4j.Logger;



/**

 * The parser class for CSV files. The {@link DataFileReader} does the parsing

 * for the record. Implements {@link RecordParsable} and {@link InsuranceFields}

 * 

 * @author VHAISFKNEELC

 *

 */

public class InsuranceRecordParser implements RecordParsable, InsuranceFields {

	

	private static Logger log = Logger.getLogger(InsuranceRecordParser.class);

	

	public InsuranceRecordParser() {

		

	}



	/* (non-Javadoc)

	 * @see gov.va.fnod.bl.RecordParsable#parseRecord(java.io.Reader)

	 */

	@Override

	public FnodCase parseRecord(Reader reader) {

		if (reader == null) {

			log.error("The reader was null was null from the parameter.");

			throw new IllegalArgumentException("The reader should not be a null value.");

		}

		BufferedReader br = (BufferedReader) reader;

		FnodCase fnodCase = new FnodCase();

		Insurance insurance = new Insurance();

		

		try {

			DataFileReader dfr = new DataFileReader(br, CsvDelimiters.Field.Pipe);

			while (dfr.next()) {

				insurance.setVeteranName(dfr.getValue(VET_NAME));

				insurance.setNameAndAddressLine1(dfr.getValue(NAME_AND_ADDRESS_LINE_1));

				insurance.setNameAndAddressLine2(dfr.getValue(NAME_AND_ADDRESS_LINE_2));

				insurance.setNameAndAddressLine3(dfr.getValue(NAME_AND_ADDRESS_LINE_3));

				insurance.setNameAndAddressLine4(dfr.getValue(NAME_AND_ADDRESS_LINE_4));

				insurance.setNameAndAddressLine5(dfr.getValue(NAME_AND_ADDRESS_LINE_5));

				insurance.setCityAndState(dfr.getValue(CITY_AND_STATE));

				insurance.setZipOrForeignCode(dfr.getValue(ZIP_OR_FOREIGN_CODE));

				insurance.setDateOfBirth(dfr.getValue(DATE_OF_BIRTH));

				insurance.setDateOfDeath(dfr.getValue(DATE_OF_DEATH));

				insurance.setInsuranceFileNumber(dfr.getValue(INSURANCE_FILE_NUMBER));

				insurance.setSocialSecurityNumber(dfr.getValue(SOCIAL_SECURITY_NUMBER));

				insurance.setClaimNumber(dfr.getValue(CLAIM_NUMBER));

				insurance.setServiceNumber(dfr.getValue(SERVICE_NUMBER));

				insurance.setSpouseName(dfr.getValue(SPOUSE_NAME));

				insurance.setSpouseAddressLine1(dfr.getValue(SPOUSE_ADDRESS_LINE_1));

				insurance.setSpouseAddressLine2(dfr.getValue(SPOUSE_ADDRESS_LINE_2));

				insurance.setSpouseAddressLine3(dfr.getValue(SPOUSE_ADDRESS_LINE_3));

				insurance.setSpouseCityAndState(dfr.getValue(SPOUSE_CITY_AND_STATE));

				insurance.setSpouseZip(dfr.getValue(SPOUSE_ZIP));

				fnodCase.setReportedDate(FNODHelper.formatXMLGregorianCalendar(dfr.getValue(FILE_DATE)));

			}

			fnodCase.setInsurance(insurance);
			fnodCase.setCaseTypeCd(CaseTypeCd.INSURANCE_REPORT);
			fnodCase.setSourceSystemCd(SourceSystemCd.INSURANCE_REPORT);
			
			
			// create veteran
			Veteran veteran = new Veteran();
			veteran.setServiceNumber(insurance.getServiceNumber());
			veteran.setClaimNumber(insurance.getClaimNumber());
			veteran.setAddress(InsuranceHelper.CreateVeteranAddress(insurance));
			veteran.setPerson(new Person());
			veteran.getPerson().setName(InsuranceHelper.CreatePersonNameFromCaseInsName(insurance.getVeteranName()));
			veteran.getPerson().setSocialSecurityNumber(insurance.getSocialSecurityNumber());
			veteran.getPerson().setDateOfBirth(FNODHelper.formatXMLGregorianCalendar(insurance.getDateOfBirth()));
			veteran.getPerson().setDateOfDeath(FNODHelper.formatXMLGregorianCalendar(insurance.getDateOfDeath()));
			
			// set FNOD values
			fnodCase.setFnod(new Fnod());
			fnodCase.getFnod().setVeteran(veteran);
			fnodCase.getFnod().setCityHomeOfRecord(veteran.getAddress().getCity());
			fnodCase.getFnod().setStateHomeOfRecored(veteran.getAddress().getStateOrProvidence());
			
			

		} catch (IOException e) {

			log.error(e.getMessage(), e.fillInStackTrace());

			throw new RuntimeException("Failed to parse the record due to a serous failure.");

		} finally {

			try {

				br.close();

			} catch (IOException e) {

				log.error(e.getMessage(), e.fillInStackTrace());

				throw new RuntimeException("Failed to close the buffered reader.");

			}

		}

		return fnodCase;

	}



}

