package gov.va.fnod.bl;

import gov.va.fnod.soa_common.model.fnod.Address;
import gov.va.fnod.soa_common.model.fnod.Insurance;
import gov.va.fnod.soa_common.model.fnod.PersonName;
import gov.va.fnod.util.DataLoadConstants;

public class InsuranceHelper {
	
	public static String ParseStateNameFromString(String cityStateStr) { 
		String [] strArr = cityStateStr.split("\\s+");
		return strArr[strArr.length-1];
	}
	
	public static String ParseCityNameFromString(String cityStateStr) { 
		String [] strArr = cityStateStr.split("\\s+");
		StringBuffer sb = new StringBuffer();
		for(int x = 0; (x <= strArr.length -2); x++ )  { 
			if(x == strArr.length-2) { 
				sb.append(strArr[x]);
			} else { 
				sb.append(strArr[x] + " ");
			}
		}
		return sb.toString();
	}

	
	public static Address CreateVeteranAddress(Insurance ins) { 
		Address vetAddress = new Address();
		vetAddress.setLine1(ins.getNameAndAddressLine1());
		vetAddress.setLine2(ins.getNameAndAddressLine2());
		vetAddress.setLine3(ins.getNameAndAddressLine3());
		vetAddress.setLine4(ins.getNameAndAddressLine4());
		vetAddress.setLine5(ins.getNameAndAddressLine5());
		vetAddress.setCity( InsuranceHelper.ParseCityNameFromString(ins.getCityAndState()));
		vetAddress.setStateOrProvidence(InsuranceHelper.ParseStateNameFromString(ins.getCityAndState()));
		vetAddress.setPostalCode(ins.getZipOrForeignCode());
		
		
		return vetAddress;
	}
	

	
	public static PersonName CreatePersonNameFromCaseInsName(String vetName) { 
		PersonName vetPersonName = new PersonName();
		String [] strArr = vetName.split("\\s+");
		boolean noSuffix = true;
		if( strArr.length == 2 ) { 
			// easy one
			vetPersonName.setFirstName(strArr[0]);
			vetPersonName.setLastName(strArr[1]);

		}else { 
			int lastElem = strArr.length-1;
			// hand a name with a suffix
			if( DataLoadConstants.NM_SUFFIX_LST.contains(strArr[lastElem].toUpperCase() )) { 
				// we have a name suffix at the end
				vetPersonName.setSuffix(strArr[lastElem]);
				lastElem--;
				vetPersonName.setLastName(strArr[lastElem]);
				lastElem--;
				noSuffix = false;
			} 


			/*
			 * We have 2 or more elements left, so we need to figure out the pattern
			 * 
			 * See JUNIT test class FnodPayloadModelMappingHelperTest
			 * 
			 * Here are the patterns we are covering
			 * 
			 * 
			 * String name = "David White";
			 * String name = "David A White";
			 * String name = "David A R White";
			 * String name = "Rueben Von Stueben";
			 * String name = "Billy Bob Thorton";
			 * String name = "Rueben A Von Stueben";
			 * String name = "Billy Bob A Thorton";
			 * String name = "Rueben A Von Stueben Sr";
			 * String name = "Billy Bob A Thorton Jr";
			 * String name = "T J Thorton Jr";
			 * String name = "Red Baron Manfred T J Von Richthofen Jr";
			 * 
			 */
			if( noSuffix ) { 
				vetPersonName.setLastName(strArr[lastElem--]);
			}

			if( lastElem == 1 && strArr[lastElem].length() == 1 ) { 
				// we have a middle and first name left 
				vetPersonName.setMiddleName(strArr[lastElem--]);
				vetPersonName.setFirstName(strArr[lastElem--]);
			}else if( lastElem == 1 && strArr[lastElem].length() > 1 && !DataLoadConstants.COMMON_3_LTR_NAMES.contains(strArr[lastElem].toLowerCase()))  {  
				// have a complex last name, Von Stueben, Mc Nally etc
				vetPersonName.setLastName(strArr[lastElem--] + " " + vetPersonName.getLastName());
				vetPersonName.setFirstName(strArr[lastElem]);
			}else if( lastElem == 1 && strArr[lastElem].length() > 1 && DataLoadConstants.COMMON_3_LTR_NAMES.contains(strArr[lastElem].toLowerCase()))  {  
				// have a complex first name, Bill Bob Thorton
				vetPersonName.setFirstName( strArr[lastElem -1] + " " +  strArr[lastElem]);
			}else if(lastElem >= 2 ) { // we still have 3 or more parts left  

				for ( int x = lastElem; x > -1; x--) { 
					// if last element > 1, we have a complex last name again, and other more complex name
					if( strArr[x].length() > 1  && x == lastElem) { 
						vetPersonName.setLastName(strArr[x] + " " + vetPersonName.getLastName() );
					} else if( strArr[x].length() == 1 && vetPersonName.getMiddleName() == null) { 
						// check for complex middle names like David A R White
						vetPersonName.setMiddleName(strArr[x]);
					} else if( x >= 1 && strArr[x].length() == 1 && vetPersonName.getMiddleName() != null ) {
						// check for complex middle names like David A R White
						vetPersonName.setMiddleName(strArr[x] + " " + vetPersonName.getMiddleName());
					} else if( x == 1  && strArr[x].length() > 1 && strArr[x-1].length() > 1 ) {
						// we have a complex first name like Mary Ann or Billy Bob
						vetPersonName.setFirstName(strArr[x-1] + " " + strArr[x]);
						x--;
					}else if( x == 0 ) { 
						vetPersonName.setFirstName(strArr[x]);
					}else { 
						// we got some crazy first name, so we are just going to append together
						// Red Baron Manfred T J Von Richthofen Jr
						for( int i = x; i > -1; i--) { 
							if( i > 0  && vetPersonName.getFirstName() == null) { 
								vetPersonName.setFirstName(" " + strArr[i]);
							} else if( i > 0 ) {  
								vetPersonName.setFirstName(" " + strArr[i] + vetPersonName.getFirstName());	
							}else { 
								vetPersonName.setFirstName(strArr[i] + vetPersonName.getFirstName());
							}

						}
						lastElem = -1;
						x = -1;
					}
				}

			}

		}

		
		return vetPersonName;
	}
}
