package gov.va.fnod.bl;

/**
 * This class is responsible for storing the Field retrieval information for all
 * the data elements in the Report
 */
public class FieldDef {
	
	/**
	 * The constructor takes the field retrieval information as input
	 * @param fieldType field Type
	 * @param startPos field beginIndex
	 * @param endPos field endIndex
	 * @param dateFormat does field requires a dateFormatter
	 */
	public FieldDef(FieldType fieldType, int startPos, int endPos,
			String dateFormat) {
		this.fieldType = fieldType;
		this.startPos = startPos;
		this.endPos = endPos;
		this.dateFormat = dateFormat;
	}
	
	private FieldType fieldType;
	private int startPos;
	private int endPos;
	private String dateFormat;

	public FieldType getFieldType() {
		return fieldType;
	}

	public void setFieldType(FieldType fieldType) {
		this.fieldType = fieldType;
	}

	public int getStartPos() {
		return startPos;
	}

	public void setStartPos(int startPos) {
		this.startPos = startPos;
	}

	public int getEndPos() {
		return endPos;
	}

	public void setEndPos(int endPos) {
		this.endPos = endPos;
	}

	public String getDateFormat() {
		return dateFormat;
	}

	public void setDateFormat(String dateFormat) {
		this.dateFormat = dateFormat;
	}

}