package gov.va.fnod.bl;

import gov.va.fnod.soa_common.model.fnod.Cemetery;
import gov.va.fnod.soa_common.model.fnod.Decedent;
import gov.va.fnod.soa_common.model.fnod.Fnod;
import gov.va.fnod.soa_common.model.fnod.FnodCase;
import gov.va.fnod.soa_common.model.fnod.Person;
import gov.va.fnod.soa_common.model.fnod.PersonName;
import gov.va.fnod.soa_common.model.fnod.Relationship;
import gov.va.fnod.soa_common.model.fnod.Veteran;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;

import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

import org.apache.log4j.Logger;

/**
 * Helper class
 */
public class FNODHelper {

	private static Logger log = Logger.getLogger(FNODHelper.class);

	/**
	 * formats the date from 'MM/dd/yyyy' to a Date object
	 * 
	 * @param dateStr
	 * @return
	 */
	public static Date formatDate(String dateStr) {
		SimpleDateFormat srcFormat = new SimpleDateFormat(
				FNODConstants.DATE_FORMAT_MMDDYYYY);
		if (dateStr != null && !dateStr.isEmpty()
				&& dateStr.matches("[0-9]{1,2}/[0-9]{1,2}/[0-9]{4}")) {
			Date date;
			try {
				date = srcFormat.parse(dateStr);
			} catch (ParseException e) {
				throw new RuntimeException("Failed to parse the dateStr "
						+ dateStr);
			}
			return date;
		}
		return null;
	}
	
	public static XMLGregorianCalendar formatXMLGregorianCalendar(String dateStr){
		GregorianCalendar gc = new GregorianCalendar(); 
		if(dateStr != null) { 
		
			if(dateStr.contains(" (per survivor report only)")) { 
				dateStr = dateStr.replace(" (per survivor report only)", "");
			}
	
			if( !dateStr.isEmpty()  && dateStr.matches("\\d{2}/\\d{2}/\\d{4}")) { 
				gc.setTime(FNODHelper.formatDate(dateStr));
			} else { 
				gc.setTime(new Date());
			}
				
			try {
				return DatatypeFactory.newInstance().newXMLGregorianCalendar(gc);
			} catch (DatatypeConfigurationException e) {
				// TODO Auto-generated catch block
				throw new RuntimeException("failed to convert to XML Gregorian calendar"+e);
			}
		}else { 
			return null;
		}
	
	}

	public static XMLGregorianCalendar convertDateToXMLCalendar(Date date){
		GregorianCalendar gc = new GregorianCalendar(); 
		if(date != null)
			gc.setTime(date);
		else
			gc.setTime(new Date());
		try {
			return DatatypeFactory.newInstance().newXMLGregorianCalendar(gc);
		} catch (DatatypeConfigurationException e) {
			// TODO Auto-generated catch block
			throw new RuntimeException("failed to convert to XML Gregorian calendar"+e);
		}
	}
	
	/**
	 * populate FNODCase date from the given Map
	 * 
	 * @param caseDataValues
	 * @return
	 */
	public FnodCase getFnodCaseData(Map<Enum<FieldType>, Object> caseDataValues) {
		log.debug("In getFnodCaseData");
		if (caseDataValues == null || caseDataValues.isEmpty()) {
			throw new IllegalArgumentException(
					"caseDataValues should be non-null non-empty");
		}

		PersonName veteranName = new PersonName();
		veteranName.setLastName((String) caseDataValues
				.get(FieldType.VETERAN_LAST_NAME));
		veteranName.setFirstName((String) caseDataValues
				.get(FieldType.VETERAN_FIRST_NAME));
		veteranName.setMiddleName((String) caseDataValues
				.get(FieldType.VETERAN_MIDDLE_NAME));
		veteranName.setSuffix((String) caseDataValues
				.get(FieldType.VETERAN_SUFFIX_NAME));

		Person veteranPerson = new Person();
		veteranPerson.setName(veteranName);
		String veteranSsn = (String) caseDataValues.get(FieldType.VETERAN_SOCIAL_SECURITY_NUM);
		if (veteranSsn != null && !"".equals(veteranSsn)) {
			veteranSsn = digitsIn(veteranSsn);
		}
		veteranPerson.setSocialSecurityNumber(veteranSsn);
		
		veteranPerson.setDecedentId((String) caseDataValues
				.get(FieldType.VETERAN_DECEDENT_ID));
		veteranPerson.setDateOfBirth(this.convertDateToXMLCalendar((Date) caseDataValues
				.get(FieldType.VETERAN_BIRTH_DT)));
		veteranPerson.setDateOfDeath(this.convertDateToXMLCalendar((Date) caseDataValues
				.get(FieldType.VETERAN_DEATH_DT)));
		veteranPerson.setDateOfInterment(this.convertDateToXMLCalendar((Date) caseDataValues
				.get(FieldType.VETERAN_RECORD_OF_INTERMENT_DT)));

		Veteran veteran = new Veteran();
		veteran.setPerson(veteranPerson);
		veteran.setAliasLastName((String) caseDataValues
				.get(FieldType.VETERAN_ALIAS_LAST_NAME));
		veteran.setServiceNumber((String) caseDataValues
				.get(FieldType.MILITARY_SERVICE_NUM));
		veteran.setBranchOfService((String) caseDataValues
				.get(FieldType.BRANCH_OF_SERVICE_CD));
		veteran.setRank((String) caseDataValues.get(FieldType.RANK_CD));
		veteran.setEnteredOnActiveDutyDate(this.convertDateToXMLCalendar((Date) caseDataValues
				.get(FieldType.ENTERED_ON_ACTIVE_DUTY_DT)));
		veteran.setReleasedFromActiveDutyDate(this.convertDateToXMLCalendar((Date)caseDataValues
				.get(FieldType.RELEASED_FROM_ACTIVE_DUTY_DT)));
		veteran.setWarPeriod((String) caseDataValues
				.get(FieldType.WAR_PERIOD_CD));
		veteran.setClaimNumber((String) caseDataValues
				.get(FieldType.VETERAN_CLAIM_NUM));
		veteran.setVeteranId((String) caseDataValues.get(FieldType.VETERAN_ID));

		if (caseDataValues.get(FieldType.CEMETERY_NUM) != null
				|| caseDataValues.get(FieldType.CEMETERY_NAME) != null
				|| caseDataValues.get(FieldType.CEMETERY_TYPE) != null) {
			Cemetery cemetery = new Cemetery();
			cemetery.setNumber((String) caseDataValues
					.get(FieldType.CEMETERY_NUM));
			cemetery.setName((String) caseDataValues
					.get(FieldType.CEMETERY_NAME));
			cemetery.setType((String) caseDataValues
					.get(FieldType.CEMETERY_TYPE));

			veteran.setCemetery(cemetery);
		}
		
		Fnod fnod = new Fnod();
		fnod.setVeteran(veteran);
		fnod.setCityHomeOfRecord((String) caseDataValues
				.get(FieldType.VETERAN_HOME_OF_RECORD_CITY));
		fnod.setStateHomeOfRecored((String) caseDataValues
				.get(FieldType.VETERAN_HOME_OF_RECORD_STATE));
		fnod.setVeteran(veteran);

		FnodCase fnodCase = new FnodCase();
		fnodCase.setFnod(fnod);
		fnodCase.setUserId((String) caseDataValues
				.get(FieldType.SOURCE_USER_ID));
		

		if (caseDataValues.get(FieldType.SPOUSE_DEATH_DT) != null) {

			PersonName spouseName = new PersonName();
			spouseName.setLastName((String) caseDataValues
					.get(FieldType.SPOUSE_LAST_NAME));
			spouseName.setFirstName((String) caseDataValues
					.get(FieldType.SPOUSE_FIRST_NAME));
			spouseName.setMiddleName((String) caseDataValues
					.get(FieldType.SPOUSE_MIDDLE_NAME));

			Person spousePerson = new Person();
			spousePerson.setName(spouseName);
			spousePerson.setDecedentId((String) caseDataValues
					.get(FieldType.SPOUSE_DECEDENT_ID));
			spousePerson.setDateOfBirth(this.convertDateToXMLCalendar((Date) caseDataValues
					.get(FieldType.SPOUSE_BIRTH_DT)));
			spousePerson.setDateOfDeath(this.convertDateToXMLCalendar((Date) caseDataValues
					.get(FieldType.SPOUSE_DEATH_DT)));
			spousePerson.setDateOfInterment(this.convertDateToXMLCalendar((Date) caseDataValues
					.get(FieldType.SPOUSE_RECORD_OF_INTERMENT_DT)));

			Decedent decedent = new Decedent();
			decedent.setPerson(spousePerson);
			decedent.setRelationship(Relationship.SPOUSE);

			fnod.setDecedent(decedent);
		}

		fnodCase.setReportedDate(this.convertDateToXMLCalendar((Date) caseDataValues
				.get(FieldType.REPORTED_DT)));

		return fnodCase;
	}

	private static String digitsIn(String source) {
		if (source == null) {
			return null;
		}
		
		StringBuilder builder = new StringBuilder(source);
		for (int i = source.length() - 1; i >= 0; i--) {
			if (builder.charAt(i) < '0' || builder.charAt(i) > '9') {
				builder.delete(i, i + 1);
			}
		}
		return builder.toString();
	}
	
	/**
	 * Extracts the Date from the Report header
	 * 
	 * @param recordDateStr
	 * @return
	 */
	public String getReportDate(StringBuilder recordDateStr) {
		if (recordDateStr == null || recordDateStr.length() == 0) {
			throw new IllegalArgumentException("recordDateStr is null or empty");
		}
		String dateStr = null;
		try {
			dateStr = recordDateStr.substring(recordDateStr.indexOf("DATE"));
		} catch (IndexOutOfBoundsException e) {
			throw new IndexOutOfBoundsException(
					"date cannot be extracted from the given recordDateStr : "
							+ recordDateStr);
		}
		return dateStr;
	}

}