package gov.va.fnod.bl;



import gov.va.cem.common.csvfile.CSVWriter;

import gov.va.cem.common.csvfile.CsvDelimiters;

import gov.va.cem.common.csvfile.DataFileReader;



import java.io.BufferedReader;

import java.io.IOException;

import java.io.Reader;



import org.apache.log4j.Logger;



/**

 * The class for splitting CSV file rows into records. Uses the

 * {@link DataFileReader} for parsing rows. Implements {@link RecordSplittable}.

 * 

 * @author VHAISFKNEELC

 *

 */

public class CvsRecordSplitter implements RecordSplittable {

	

	private static Logger log = Logger.getLogger(CvsRecordSplitter.class);

	private CsvDelimiters.Field fieldDelimiter;



	public CvsRecordSplitter(CsvDelimiters.Field fieldDelimiter) {

		this.fieldDelimiter = fieldDelimiter;

	}



	/* (non-Javadoc)

	 * @see gov.va.fnod.bl.RecordSplittable#splitRecords(java.io.Reader, gov.va.fnod.bl.SplitterCallbackInterface)

	 */

	@Override

	public void splitRecords(Reader reader, SplitterCallbackInterface splitterCallback) {

		if (reader == null) {

			log.error("The reader was null was null from the parameter.");

			throw new IllegalArgumentException("The Reader should not be a null value.");

		}

		int rowCnt = -1;// row count

		

		BufferedReader br;

		if ( reader instanceof BufferedReader ) {

			br = (BufferedReader) reader;

		} else {

			br = new BufferedReader(reader);

		}

		

		String[] rowValues = null;

		String recordString = null;



		try {

			DataFileReader dataFileReader = new DataFileReader(br, fieldDelimiter);

			CSVWriter csvWriter = new CSVWriter(fieldDelimiter);



			while (dataFileReader.next()) {

				rowCnt++;

				recordString = null;

				if (rowCnt != 0 && !dataFileReader.isFieldCountMismatch()) {

					rowValues = dataFileReader.getValues();

					recordString = csvWriter.write(rowValues);

					splitterCallback.writeRecord(recordString.toString(), String.format(".%06d",rowCnt));

				}else if (rowCnt != 0 && dataFileReader.isFieldCountMismatch()) { 
					recordString = csvWriter.write(dataFileReader.getValues());
					log.error("The following record did not have the correct number of fileds: " + recordString);
				}

			}

		} catch (IOException e) {

			log.error(e.getMessage(), e.fillInStackTrace());

			throw new RuntimeException("Failed to read the file.");

		} finally {

			try {

				br.close();

			} catch (IOException e) {

				log.error(e.getMessage(), e.fillInStackTrace());

				throw new RuntimeException("Failed to close the reader");

			}

		}

	}



	@Override
	public void splitBossSpouseRecords(Reader reader,
			SplitterCallbackInterface splitterCallback) {
		
		
	}

}

