package gov.va.fnod.be;



/**

 * Enumeration for SourceReportType

 */

public enum SourceReportType {



	BOSS_FNOD("FNOD", "BOSS"), 

	BOSS_FNOD_SPOUSE("FNOD_SPOUSE", "BOSS"), 

	AMAS_FNOD("FNOD", "AMAS"), 

	AMAS_FNOD_SPOUSE("FNOD_SPOUSE", "AMAS"), 

	FLAG_APPLICATION("FLAG_APPLICATION", "FLAG_APPLICATION"), 

	INSURANCE_REPORT("INSURANCE_REPORT","INSURANCE_REPORT"),

	

	ANC_FNOD("FNOD","ANC"),
	
	ANC_FNOD2("FNOD","ANC"),
	

	ANC_FNOD_SPOUSE("FNOD_SPOUSE","ANC"),

	ANC_FNOD_SPOUSE2("FNOD_SPOUSE","ANC"),

	PRUDENTIAL_INSURANCE("PRUDENTIAL_INSURANCE", "PRUDENTIAL_INSURANCE");



	private final String reportType;

	private final String sourceSystem;



	SourceReportType(String reportType, String sourceSystem) {

		this.reportType = reportType;

		this.sourceSystem = sourceSystem;

	}



	public String getReportType() {

		return reportType;

	}



	public String getSourceSystem() {

		return sourceSystem;

	}



	/**

	 * get Enumeration from String

	 * 

	 * @param sourceReportTypeStr

	 * @return

	 */

	public static SourceReportType getEnum(String sourceReportTypeStr) {

		

		if ( sourceReportTypeStr == null || sourceReportTypeStr.isEmpty() ) {

			throw new IllegalArgumentException("getEnum requires a non-null/not empty value");

		}

		

		SourceReportType srcRptType = SourceReportType.valueOf(sourceReportTypeStr.toUpperCase());

		if ( srcRptType == null ) {

			throw new IllegalArgumentException(

				"No Enum specified for sourceReportTypeStr "

					+ sourceReportTypeStr);

		}

		return srcRptType;

	

	}

}