package gov.va.fnod.be;

import gov.va.fnod.util.EqualsHelper;

/**
 * This class is responsible for storing the parameters for Report
 */
public class ReportConfigEntity {

	/**
	 * The constructor takes the configuration parameters as input
	 * 
	 * @param sourceReportType
	 *            Source Report Type
	 * @param filenamePattern
	 *            filename pattern
	 * @param inputDirPath
	 *            input directory path
	 * @param workingDirPath
	 *            working directory path
	 * @param completedDirPath
	 *            completed directory path
	 */
	public ReportConfigEntity(SourceReportType sourceReportType,
			String filenamePattern, String inputDirPath, String workingDirPath,
			String completedDirPath) {
		this.sourceReportType = sourceReportType;
		this.filenamePattern = filenamePattern;
		this.inputDirPath = inputDirPath;
		this.workingDirPath = workingDirPath;
		this.completedDirPath = completedDirPath;
	}

	private String inputDirPath;
	private String workingDirPath;
	private String completedDirPath;
	private String filenamePattern;
	private SourceReportType sourceReportType;

	public String getInputDirPath() {
		return inputDirPath;
	}

	public void setInputDirPath(String inputDirPath) {
		this.inputDirPath = inputDirPath;
	}

	public String getWorkingDirPath() {
		return workingDirPath;
	}

	public void setWorkingDirPath(String workingDirPath) {
		this.workingDirPath = workingDirPath;
	}

	public String getCompletedDirPath() {
		return completedDirPath;
	}

	public void setCompletedDirPath(String completedDirPath) {
		this.completedDirPath = completedDirPath;
	}

	public String getFilenamePattern() {
		return filenamePattern;
	}

	public void setFilenamePattern(String filenamePattern) {
		this.filenamePattern = filenamePattern;
	}

	public SourceReportType getSourceReportType() {
		return sourceReportType;
	}

	public void setSourceReportType(SourceReportType sourceReportType) {
		this.sourceReportType = sourceReportType;
	}

	/**
	 * The equals method has been overridden for testing purposes. This
	 * implementation meets the guidelines of the equals/hashCode contract.
	 * 
	 * @param obj
	 * @return
	 */
	@Override
	public boolean equals(Object obj) {
		if (obj instanceof ReportConfigEntity) {
			ReportConfigEntity reportConfig = (ReportConfigEntity) obj;
			return EqualsHelper.objectsEqual(sourceReportType,
					reportConfig.getSourceReportType())
					&& EqualsHelper.objectsEqual(filenamePattern,
							reportConfig.getFilenamePattern())
					&& EqualsHelper.objectsEqual(inputDirPath,
							reportConfig.getInputDirPath())
					&& EqualsHelper.objectsEqual(workingDirPath,
							reportConfig.getWorkingDirPath())
					&& EqualsHelper.objectsEqual(completedDirPath,
							reportConfig.getCompletedDirPath());
		}
		return false;
	}

	/**
	 * The hashCode method has been overridden for testing purposes. This
	 * implementation meets the guidelines of the equals/hashCode contract.
	 * 
	 * @return
	 */
	@Override
	public int hashCode() {
		int hash;
		hash = EqualsHelper.hashCode(sourceReportType, filenamePattern,
				inputDirPath, workingDirPath, completedDirPath);
		return hash;
	}

}