package gov.va.fnod.be;

import gov.va.fnod.soa_common.model.ServiceConnectionParams;

import java.util.Map;

/**
 * This is a data transport entity used for storing and passing around runtime
 * configuration data. The data stored in instances of this class are used to
 * initialize database connection and as parameters of configurable static data
 * used as process parameters.
 */
public class ConfigEntity {

	public ConfigEntity() {

	}

	private ServiceConnectionParams connectionParams;
	private Map<SourceReportType, ReportConfigEntity> reportConfigs;
	private String xmlFilename;

	public ServiceConnectionParams getConnectionParams() {
		return connectionParams;
	}

	public void setConnectionParams(ServiceConnectionParams connectionParams) {
		this.connectionParams = connectionParams;
	}

	public Map<SourceReportType, ReportConfigEntity> getReportConfigs() {
		return reportConfigs;
	}

	public void setReportConfigs(
			Map<SourceReportType, ReportConfigEntity> reportConfigs) {
		this.reportConfigs = reportConfigs;
	}

	public String getXmlFilename() {
		return xmlFilename;
	}

	public void setXmlFilename(String xmlFilename) {
		this.xmlFilename = xmlFilename;
	}

}