package gov.va.cem.common.pdfutils;

import com.lowagie.text.pdf.PdfReader;

import com.lowagie.text.pdf.RandomAccessFileOrArray;

import java.io.File;
import java.io.IOException;

public class PageCounter {

    private PageCounter() {
    }

    public static int countPages(File file) {
        int retval = -1;
        PdfReader pdfReader;
        try {
            pdfReader =
                    new PdfReader(new RandomAccessFileOrArray(file.getAbsolutePath()),
                                  null);
            try {
                retval = pdfReader.getNumberOfPages();
                return retval;
            } finally {
                pdfReader.close();
            }
        } catch (IOException e) {
            throw new RuntimeException("Failed to get number of pages: " +
                                       file.getPath(), e);
        }
    }
}
