package gov.va.cem.common.pdfutils;



import com.lowagie.text.PageSize;

import com.lowagie.text.Rectangle;



public class ImageSizeCalcForPdfExport extends ImageSizeCalcBase {

    public ImageSizeCalcForPdfExport() {

    }



    /**

     * Computes the page size needed to fit image.  Pages are normalized

     * to Portrait sizes requiring calling routine to rotate for landscape.

     * <p />

     * Return LETTER, LEGAL or 11x17 page size

     * @return Rectangle of LETTER, LEGAL or 11x17

     */

    @Override

    public Rectangle calculatePageSize() {



        float pageHeight;

        float pageWidth;

        Rectangle pageSize = PageSize.LETTER;



        // Normalize orientation of page so height is greater than width

        // This will simplify page size calculatiion to only Potrait sizes.

         if (getImage().getWidth() > getImage().getHeight()) {

             pageWidth = getWidthInInches();

             pageHeight = getHeightInInches();

         } else {

             pageWidth = getHeightInInches();

             pageHeight = getWidthInInches();

         } 



        if (pageWidth > 9f)

            pageSize = PageSize._11X17;

        else if (pageHeight < 14.5 && pageHeight > 11.5)

            pageSize = PageSize.LEGAL;

        else

            pageSize = PageSize.LETTER;



        return pageSize;

    }

    

    @Override

    public PageMargin calculatePageMargins() {

        return new PageMargin(9,9,9,9);

    }



    protected void adjustImage() {

        

        if ( getImage().getWidth() > getImage().getHeight() ) {

            rotateImage(Rotate.COUNTER_CLOCKWISE);

        }

        

        scaleImageToPageSize();

    }

}

