package gov.va.cem.common.pdfutils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.PdfWriter;

public class ImageOnlyPdfFileWriter {

    private PdfImagePageFormatter pageSizeCalculator;

    public ImageOnlyPdfFileWriter() {
        this.pageSizeCalculator = new ImageSizeCalcForPdfExport();
    }
    
    public ImageOnlyPdfFileWriter(PdfImagePageFormatter pageSizeCalculator) {
        this.pageSizeCalculator = pageSizeCalculator;
    }

    public void write(File pdfFile,
                      Iterable<File> imageFiles) throws IllegalArgumentException,
                                                        PDFCreateException {
        try {
            FileOutputStream fos = new FileOutputStream(pdfFile);
            try {
                // dimensions are in points (72 per Inch) 1/8 margins
                Document pdfDoc = new Document();

                
                try {                	
                	PdfWriter.getInstance(pdfDoc, fos);
                    pdfDoc.open();

                    boolean hasImages = false;
                    for (File file : imageFiles) {

                        hasImages = true;

                        if (!file.isFile()) {
                            throw new FileNotFoundException("Image file not found " +
                                                            file.getAbsolutePath());
                        }

                        Image img = Image.getInstance(file.getAbsolutePath());

                        pageSizeCalculator.prepareImage(img);

                        pdfDoc.setPageSize(pageSizeCalculator.getPageSize());

                        PageMargin margin =
                            pageSizeCalculator.getPageMargins();
                        pdfDoc.setMargins(margin.getLeft(), margin.getRight(),
                                          margin.getTop(), margin.getBottom());

                        pdfDoc.newPage();
                        pdfDoc.add(img);
                    }

                    if (!hasImages) {
                        pdfDoc.add(new Paragraph("This document has no images."));
                    }

                    pdfDoc.close();

                } catch (DocumentException e) {
                    throw new PDFCreateException("Failed to create pdf ", e);
                }

            } finally {
                fos.close();
            }
        } catch (FileNotFoundException ex) {
            throw new PDFCreateException("Failed to create pdf ", ex);

        } catch (IOException ex) {
            throw new PDFCreateException("Failed to create pdf ", ex);
        }
    }
}


