package gov.va.cem.common.modelutils;



import java.util.HashMap;

import java.util.Map;





public class CaseAndSourceSystemMapper {

	

	static Map<Long, CaseOrigin> idToDetailMap = new HashMap<Long, CaseOrigin>();

	static Map<CaseOrigin, Long> detailToIdMap= new HashMap<CaseOrigin, Long>();

	

	static {

		idToDetailMap.put(1L, new CaseOrigin(1L, 1L));

		idToDetailMap.put(2L, new CaseOrigin(2L, 1L));

		idToDetailMap.put(3L, new CaseOrigin(1L, 2L));

		idToDetailMap.put(4L, new CaseOrigin(2L, 2L));

		idToDetailMap.put(5L, new CaseOrigin(3L, 3L));

		idToDetailMap.put(6L, new CaseOrigin(4L, 4L));

		idToDetailMap.put(7L, new CaseOrigin(5L, 1L));

		idToDetailMap.put(8L, new CaseOrigin(5L, 2L));

		idToDetailMap.put(9L, new CaseOrigin(6L, 4L));

		

		// Now invert the mapping for lookups

		for ( Long key: idToDetailMap.keySet() ) {

			detailToIdMap.put(idToDetailMap.get(key),key);

		}				

	}

	

	public static CaseOrigin convert(Long sourceCaseTypeMapId) {

		return idToDetailMap.get(sourceCaseTypeMapId);

	}

	

	public static Long convert(Long caseTypeId, Long sourceTypeId) {

		return convert(new CaseOrigin(caseTypeId, sourceTypeId));

	}

	

	static Long convert(CaseOrigin caseDetail) {

		return detailToIdMap.get(caseDetail);

	}

}

