package gov.va.cem.common.dateutils;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class DateHelper {

    public DateHelper() {
    }
    
    /**
    *
    * @return The date for 01-01-1900 
    */
   public static Date get1900() {
   		Date dateOut = null;
   	
	   	try {
	   		Calendar cal = Calendar.getInstance();   
			cal.set(Calendar.YEAR, 1900);   
			cal.set(Calendar.MONTH, 0);   
			cal.set(Calendar.DAY_OF_MONTH, 0);   
			cal.set(Calendar.HOUR_OF_DAY, 0);   
			cal.set(Calendar.MINUTE, 0);   
			cal.set(Calendar.SECOND, 0);   
			cal.set(Calendar.MILLISECOND, 0);   
			  
			dateOut = new Date(cal.getTime().getTime());
	   	}
	   	
	   	catch (Exception e) {
	   		e.printStackTrace();
	   	}
	   	
	   	return dateOut;
   }

    /**
     *
     * @param dateIn The date to remove the time from
     * @return The input date with the time removed (reset to 00:00:00)
     */
    public static Date removeTime(Date dateIn) {
    	Date dateOut = null;
    	
    	try {
    		Calendar cal = Calendar.getInstance();   
    		cal.setTime(dateIn);   
    		  
    		cal.set(Calendar.HOUR_OF_DAY, 0);   
    		cal.set(Calendar.MINUTE, 0);   
    		cal.set(Calendar.SECOND, 0);   
    		cal.set(Calendar.MILLISECOND, 0);   
    		  
    		dateOut = new Date(cal.getTime().getTime());
    	}
    	
    	catch (Exception e) {
    		e.printStackTrace();
    	}
    	
    	return dateOut;
    }

    /**
     *
     * @param dateIn The date to count 12 months back from 
     * @return The minimum date from the input date back, where the range includes only 12 months
     */
    public static Date getTwelveMonthMin(Date dateIn) {
    	Date dateOut = null;
    	
    	try {
    		GregorianCalendar cal = new GregorianCalendar();   
    		cal.setTime(dateIn);   
    		  
    		cal.add(Calendar.YEAR, -1);
    		cal.add(Calendar.MONTH, 1);
			cal.set(Calendar.DAY_OF_MONTH, 1);   
    		cal.set(Calendar.HOUR_OF_DAY, 0);   
    		cal.set(Calendar.MINUTE, 0);   
    		cal.set(Calendar.SECOND, 0);   
    		cal.set(Calendar.MILLISECOND, 0);   
    		  
    		dateOut = new Date(cal.getTime().getTime());
    	}
    	
    	catch (Exception e) {
    		e.printStackTrace();
    	}
    	
    	return dateOut;
    }

    /**
     *
     * @param dateIn The date to count 12 months from 
     * @return The maximum date from the input date, where the range includes only 12 months
     */
    public static Date getTwelveMonthMax(Date dateIn) {
    	Date dateOut = null;
    	
    	try {
    		GregorianCalendar cal = new GregorianCalendar();   
    		cal.setTime(dateIn);
    		  
    		cal.add(Calendar.YEAR, 1);
			cal.set(Calendar.DAY_OF_MONTH, 1);   
    		cal.set(Calendar.HOUR_OF_DAY, 0);   
    		cal.set(Calendar.MINUTE, 0);   
    		cal.set(Calendar.SECOND, 0);   
    		cal.set(Calendar.MILLISECOND, 0);   
    		cal.add(Calendar.MILLISECOND, -1);
    		  
    		dateOut = new Date(cal.getTime().getTime());
    	}
    	
    	catch (Exception e) {
    		e.printStackTrace();
    	}
    	
    	return dateOut;
    }
    
    /**
    *
    * @param dateIn The date to add 1 day to 
    * @return The input date with 1 day added
    */
   public static Date addOneDay(Date dateIn) {
   		Date dateOut = null;
   	
	   	try {
	   		GregorianCalendar cal = new GregorianCalendar();   
    		cal.setTime(dateIn);
    		  
    		cal.add(Calendar.DAY_OF_MONTH, 1);
    		  
    		dateOut = new Date(cal.getTime().getTime());
	   	}
	   	
	   	catch (Exception e) {
	   		e.printStackTrace();
	   	}
	   	
	   	return dateOut;
   }
   
   /**
   *
   * @param dateIn The date to subtract 1 day from 
   * @return The input date with 1 day subtracted
   */
  public static Date subtractOneDay(Date dateIn) {
  		Date dateOut = null;
  	
	   	try {
	   		GregorianCalendar cal = new GregorianCalendar();   
    		cal.setTime(dateIn);
    		  
    		cal.add(Calendar.DAY_OF_MONTH, -1);
    		  
    		dateOut = new Date(cal.getTime().getTime());
	   	}
	   	
	   	catch (Exception e) {
	   		e.printStackTrace();
	   	}
	   	
	   	return dateOut;
  }
    
    /**
    *
    * @param dateIn The date to 1 year from
    * @return The input date minus 1 year
    */
   public static Date subtractOneYear(Date dateIn) {
	   	Date dateOut = null;
	   	
	   	try {
	   		dateOut = new Date(dateIn.getTime() - (1000l * 60l * 60l * 24l * 365l));
	   	}
	   	
	   	catch (Exception e) {
	   		e.printStackTrace();
	   	}
	   	
	   	return dateOut;
   }
   

   public static Timestamp beginningOfDay(Timestamp dateInstance) {
	   Calendar c = Calendar.getInstance();
	   c.setTimeInMillis(dateInstance.getTime());
	   c.set(Calendar.HOUR_OF_DAY, 0);
	   c.set(Calendar.MINUTE, 0);
	   c.set(Calendar.SECOND, 0);
	   c.set(Calendar.MILLISECOND, 0);
	   Timestamp t = new Timestamp(c.getTimeInMillis());
	   return t;
   }
   
   public static Timestamp endOfDay(Timestamp dateInstance) {
	   Calendar c = Calendar.getInstance();
	   c.setTimeInMillis(dateInstance.getTime());
	   c.set(Calendar.HOUR_OF_DAY, 23);
	   c.set(Calendar.MINUTE, 59);
	   c.set(Calendar.SECOND, 59);
	   c.set(Calendar.MILLISECOND, 999);
	   Timestamp t = new Timestamp(c.getTimeInMillis());
	   return t;
   }
   
	public static final int getMonthsDifference(Date date1, Date date2) {
		GregorianCalendar c1 = new GregorianCalendar();
		c1.setTime(date1);

		GregorianCalendar c2 = new GregorianCalendar();
		c2.setTime(date2);

		int m1 = c1.get(Calendar.YEAR) * 12 + c1.get(Calendar.MONTH);
		int m2 = c2.get(Calendar.YEAR) * 12 + c2.get(Calendar.MONTH);
		
		return m2 - m1 + 1;
	}

}