package gov.va.cem.common.csvfile;

/**
 *  Raised when a method is called in CSVReader while the reader is in an 
 *  invalid state ( ie: calling getFields when next returned false ).
 */
public class InvalidOperationException extends RuntimeException {

	private static final long serialVersionUID = -918316187315265742L;

	/**
     *  Default contructor, calls super().
     */
    public InvalidOperationException() {
        super();
    }

    /**
     * Constructor with message.
     * @param msg message to be displayed with exception
     */
    public InvalidOperationException(String msg) {
        super(msg);
    }

    /**
     * Allows for message text and nesting of exceptions.
     * @param msg message to be displayed with exception
     * @param cause nested exception
     */
    public InvalidOperationException(String msg, Throwable cause) {
        super(msg, cause);
    }

    /**
     * Allows for nesting of exceptions.
     * @param cause nested exception
     */
    public InvalidOperationException(Throwable cause) {
        super(cause);
    }
}
