package gov.va.cem.common.csvfile;

/**
 * The exception indicates that parsing error was encountered during the parsing
 * of CSV data.
 */
public class InvalidCSVFormatException extends RuntimeException {

	private static final long serialVersionUID = 5833314466757981694L;

	/**
      *  Default contructor, calls super().
      */
     public InvalidCSVFormatException() {
         super();
     }

     /**
      * Constructor with message.
      * @param msg message to be displayed with exception
      */
     public InvalidCSVFormatException(String msg) {
         super(msg);
     }

     /**
      * Allows for message text and nesting of exceptions.
      * @param msg message to be displayed with exception
      * @param cause nested exception
      */
     public InvalidCSVFormatException(String msg, Throwable cause) {
         super(msg, cause);
     }

     /**
      * Allows for nesting of exceptions.
      * @param cause nested exception
      */
     public InvalidCSVFormatException(Throwable cause) {
         super(cause);
     }

}
