package gov.va.cem.common.csvfile;

/**
 * Provides common accessors for fieldDelimiter and quoteDelimiter.
 */
public class CSVBase {

    /**
     * Value specifying which delimiter to use between fields.
     */
    protected CsvDelimiters.Field fieldDelimiter;
    
    /**
     * Value specifying which delimiter to use arround fields.
     */
    protected CsvDelimiters.Quote quoteDelimiter;
    
    /**
     * Actual character used as field delimiter.
     */
    protected char fieldDelimiterChar;
    
    /**
     * Actual character used as quote delimiter.
     */
    protected char quoteDelimiterChar;
    

    /**
     * Defaults fieldDelimiter and quoteDelimiter.
     * @see CsvDelimiters
     */
    public CSVBase() {
        this(CsvDelimiters.Field.Default, CsvDelimiters.Quote.Default);
    }

    /**
     * Defaults fldQuote = defQuote.
     * @param fieldDelimiter value representing delimiter to be used between fields
     * @see CsvDelimiters
     */
    public CSVBase(CsvDelimiters.Field fieldDelimiter) {
        this(fieldDelimiter, CsvDelimiters.Quote.Default);
    }

    /**
     * Sets fieldDelimter and quoteDelimter to specified values.
     * @param fieldDelimiter value representing delimiter to be used between fields
     * @param quoteDelimiter value representing delimiter to be used arround fields
     * @see CsvDelimiters
     */
    public CSVBase(CsvDelimiters.Field fieldDelimiter, 
                   CsvDelimiters.Quote quoteDelimiter) {
        
        this.fieldDelimiter = fieldDelimiter;
        this.quoteDelimiter = quoteDelimiter;
        
        this.fieldDelimiterChar = fieldDelimiter.getCharValue();
        this.quoteDelimiterChar = quoteDelimiter.getCharValue();
    }
    
    /**
     * This constructor allows for field and quote delimiters outside the defined enum
     * values.  Using this methods caused the returned fieldDelimiter and quoteDelimiter
     * values to be Custom.
     * @param fieldDelimiterChar 
     * @param quoteDelimiterChar
     */
    public CSVBase(char fieldDelimiterChar, char quoteDelimiterChar) {        
        this.fieldDelimiter = CsvDelimiters.Field.Custom;
        this.quoteDelimiter = CsvDelimiters.Quote.Custom;
        
        this.fieldDelimiterChar  = fieldDelimiterChar;
        this.quoteDelimiterChar = quoteDelimiterChar;        
    }
}
