package gov.va.cem.common.csvfile;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;


/**
 * Byte order marker detector
 */
class BOMDector {

    static final String UTF8 = "UTF-8";
    static final String UTF16BE = "UTF-16BE";
    static final String UTF16LE = "UTF-16LE";
    static final String UTF32BE = "UTF-32BE";
    static final String UTF32LE = "UTF-32LE";
    static final char bomChar = '\uFEFF';
    
    private static final String bomStr = String.valueOf(bomChar);

    private static final String[] CHAR_SETS =
    { UTF8, UTF16BE, UTF16LE, UTF32BE, UTF32LE };

    private static final byte[][] BOMS = new byte[CHAR_SETS.length][];

    static {

        for (int i = 0; i < CHAR_SETS.length; i++) {
            try {
                BOMS[i] = bomStr.getBytes(CHAR_SETS[i]);
            } catch (UnsupportedEncodingException e) {
                // This should never happen, but just in case
                throw new RuntimeException(e);
            }
        }
    }


    static String getEncoding(File file) throws FileNotFoundException,
                                                IOException {

        FileInputStream fis = new FileInputStream(file);
        try {
        	
        	InputStreamReader isr = new InputStreamReader(fis);
        	String charSet = isr.getEncoding();
            /*String charSet = null;
            byte[] fileBytes = new byte[4];
            fis.read(fileBytes, 0, 4);
            for (int i = 0; i < BOMS.length && charSet == null; i++) {
                byte[] bom = Arrays.copyOf(fileBytes, BOMS[i].length);
                if (Arrays.equals(bom,BOMS[i])) {
                    charSet = CHAR_SETS[i];
                }
            }
            */
            return charSet;

        } finally {
            fis.close();
        }

    }

    private BOMDector() {
    }

}
