/*
Please adjust the parameters as needed
Drop MV - needs owner
Create MV - needs owner, dblink and refresh rate
View - needs owner

Below are example of refresh

on kskdev: @intr_schedule_mv "boss" "dev.qitcdev01.cem.domain" "refresh fast start with to_date(to_char(sysdate+1,'mm/dd/yyyy') || ' 22:00:00','/mm/dd/yyyy hh24:mi:ss') next sysdate + 1" 

so it won't refresh do on kskdev:
@intr_schedule_mv boss "dev.cem.domain" "never refresh" 

*/

/* 
Drop MV Intr_Schedule
*/

@drop_intrsched_mv.sql "boss"


/*
Create MV Intr_Schedule 
*/

@intr_schedule_mv "boss" "dev.qitcdev01.cem.domain" "refresh fast start with to_date(to_char(sysdate+1,'mm/dd/yyyy') || '22:00:00','/mm/dd/yyyy hh24:mi:ss') next sysdate + 1" 

/*
Create View
*/

@burialschedule_view "boss"
@cemetery_view "boss"

/*
Analyze tables
*/
@analyze

/*
grants to kiosk_role
*/
@grant_mv "boss" "sys_user" "amasr"

--conn /as sysdba

@publicsynonym "boss"