CREATE OR REPLACE FORCE VIEW &1..BURIAL_SCHEDULE_V
("ID", "STATUS", "SCHEDULED_DATE_TIME", "SCHEDULED_DATE", "SCHEDULED_TIMESTAMP", "SCHEDULED_TIME", "FIRST_NAME", "MIDDLE_NAME", "LAST_NAME", "SUFFIX", "CEMETERY_ID", "CEMETERY_NAME", "CEMETERY_CITY", "CEMETERY_STATE", "FUNERAL_HOME", "URL") AS 
SELECT 
ROWNUM AS ID,
INTR_SCHEDULE.SCHEDULE_STATUS_CD AS STATUS,
INTR_SCHEDULE.SCHEDULED_DT AS SCHEDULED_DATE_TIME,
TO_DATE(INTR_SCHEDULE.SCHEDULED_DT,'dd-MON-yyyy') AS SCHEDULED_DATE,
CAST (INTR_SCHEDULE.SCHEDULED_DT AS TIMESTAMP) AS SCHEDULED_TIMESTAMP,
TO_CHAR (INTR_SCHEDULE.SCHEDULED_DT, 'HH:MI AM') AS SCHEDULED_TIME,
DECEDENT_INFORMATION.FIRST_NME AS FIRST_NAME,
DECEDENT_INFORMATION.MIDDLE_NME AS MIDDLE_NAME,
DECEDENT_INFORMATION.LAST_NME AS LAST_NAME,
DECEDENT_INFORMATION.SUFFIX_NME AS SUFFIX,
CEMETERY.NUM AS CEMETERY_ID,
CEMETERY.NME AS CEMETERY_NAME,
CEMETERY.CITY_NME AS CEMETERY_CITY,
CEMETERY.STATE_CD AS CEMETERY_STATE,
FUNERAL_HOME.NME AS FUNERAL_HOME,
URL_INFORMATION.URL_DESCR AS URL
FROM INTR_SCHEDULE 
INNER JOIN CEMETERY ON INTR_SCHEDULE.CEMETERY_NUM=CEMETERY.NUM 
AND CEMETERY.CEMETERY_TYPE NOT IN ('A','S','I')
INNER JOIN DECEDENT_INFORMATION ON INTR_SCHEDULE.DECEDENT_ID=DECEDENT_INFORMATION.ID
LEFT OUTER JOIN DECEDENT_CONTACT ON INTR_SCHEDULE.DECEDENT_ID=DECEDENT_CONTACT.DECEDENT_ID
LEFT OUTER JOIN CONTACT_INFORMATION ON DECEDENT_CONTACT.CONTACT_ID=CONTACT_INFORMATION.ID
LEFT OUTER JOIN FUNERAL_HOME ON CONTACT_INFORMATION.FUNERAL_HOME_ID=FUNERAL_HOME.ID
LEFT OUTER JOIN URL_INFORMATION ON CEMETERY.NUM = URL_INFORMATION.STATION_NUM AND CEMETERY.CEMETERY_TYPE=URL_INFORMATION.STATION_TYPE
WHERE INTR_SCHEDULE.SCHEDULED_DT >= TRUNC(SYSDATE)
AND INTR_SCHEDULE.SCHEDULE_STATUS_CD IN ('T','S')
/

CREATE OR REPLACE FORCE VIEW &1..CEMETERY_V 
("NUM", "NME", "STATE_CD", "DESCR", "MANAGING_STATION_NUM", "CEMETERY_TYPE", "LINE_ONE_ADDR", "LINE_TWO_ADDR", "CITY_NME", 
"ZIP_FIVE_CD", "PHONE_AREA_CODE_ONE_NUM", "PHONE_AREA_CODE_TWO_NUM", "PHONE_ONE_NUM", "PHONE_TWO_NUM") AS 
SELECT C.NUM, C.NME, C.STATE_CD, SP.DESCR, C.MANAGING_STATION_NUM, C.CEMETERY_TYPE,
C.LINE_ONE_ADDR, C.LINE_TWO_ADDR, C.CITY_NME, C.ZIP_FIVE_CD, C.PHONE_AREA_CODE_ONE_NUM, 
C.PHONE_AREA_CODE_TWO_NUM, C.PHONE_ONE_NUM, C.PHONE_TWO_NUM
FROM CEMETERY C
LEFT JOIN STATE_PROVINCE SP ON C.STATE_CD = SP.CD
WHERE SP.COUNTRY_CD = 'US' AND C.CEMETERY_TYPE NOT IN ('A','S','I')
ORDER BY C.STATE_CD, C.NME
/
