<%@ page session="false" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<c:url value="/" var="contextUri"/>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
	<!-- START: META DATA -->
	<meta http-equiv="content-type" content="text/html; charset=UTF-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
	<meta name="language" content="en">
	<meta name="author" content="National Cemetery Administration">
	<meta name="subject" content="National Cemetery Administration">
	<meta name="keywords" content="headstones, markers, cemetery, cemeteries, cemetary, burial, benefits, headstone, marker, veterans, military, national cemetery, national cemeteries, military records, medals, grave">
	<meta name="description" content="The VA National Cemetery Administration honors the military service of our Nation's veterans.  We provide a dignified burial and lasting memorial for veterans and their eligible family members and we maintain our veterans' cemeteries as national shrines.">
	<meta name="datecreated" content="20080429">
	<meta name="datereviewed" content="20141201">
	<meta name="type" content="Homepage">
	<!-- END: META DATA -->

	<title>National Cemetery Administration - Cemetery Burial Schedule</title>

	<style type="text/css" media="screen,print">
		@import url(http://www.cem.domain/CEM/styles/site-styles.css);
	</style>
			
	<link href="http://www.cem.domain/va_files/2012/styles/template_styles.css" media="all" rel="stylesheet" type="text/css">
	<link href="http://www.cem.domain/va_files/2012/styles/image_gallery.css" media="all" rel="stylesheet" type="text/css"><!-- Different Stylesheet for the Homepage -->
	<link href="http://www.cem.domain/va_files/2012/styles/slide-menu-ns.css" media="all" rel="stylesheet" type="text/css"><!-- Left Nav styles -->
	<link href="http://www.cem.domain/va_files/2012/styles/slide-menu-custom.css" media="all" rel="stylesheet" type="text/css"><!-- Left Nav styles -->  
	<link href="http://www.cem.domain/va_files/2012/styles/tabs.css" media="all" rel="stylesheet" type="text/css"><!-- Different Stylesheet for the Homepage -->
 
	<!--[if IE]><link type="text/css" rel="stylesheet" media="all" href="http://www.cem.domain/va_files/2012/styles/ie9all.css" /><![endif]-->
	<!--[if lt IE 8]><link type="text/css" rel="stylesheet" media="all" href="http://www.cem.domain/va_files/2012/styles/ie7.css" /><![endif] -->
	<!--[if IE 8]><link type="text/css" rel="stylesheet" media="all" href="http://www.cem.domain/va_files/2012/styles/ie8.css" /><![endif]-->

<!-- ****************************** LINKS TO JAVASCRIPT CODE FOR PAGES *********************************** -->

	<!-- ****************************** LINKS TO JAVASCRIPT CODE FOR PAGES *********************************** -->

	<!-- jQuery Library  -->
	<script src="http://www.cem.domain/va_files/2012/scripts/jquery-1-10-1-min.js" type="text/javascript"></script>
	<script src="http://www.cem.domain/va_files/2012/scripts/tabs.js" type="text/javascript"></script>
	<script src="http://www.cem.domain/va_files/2012/scripts/jquery-tools-min.js" type="text/javascript"></script>
	<script type="text/javascript" src="http://www.cem.domain/va_files/2012/scripts/script.js"></script>
	<script type="text/javascript" src="<c:url value='/static/va_files/foresee/foresee-trigger.js' />"></script>
	<script id="_fed_an_js_tag" type="text/javascript" src="http://www.cem.domain/va_files/scripts/federated-analytics-1-7-2-min.js?agency=VA&amp;pua=UA-46839167-1&amp;sp=QT&amp;ext=asf,psd,rm,ram,wav,dwg,eps,mpg,mpeg&amp;yt=true"></script>
	<script src="http://www.cem.domain/va_files/2012/scripts/accessible-megamenu.js" type="text/javascript"></script>

	<!-- left nav function -->
	<script type="text/javascript" src="<c:url value='/static/va_files/2012/scripts/left-nav.js'/>"></script>

	<!-- Page Specific css & javascript-->
	<link rel="stylesheet" type="text/css" href="<c:url value='/static/jquery/css/jquery.dataTables.css'/>" />
  	<link rel="stylesheet" href="<c:url value='/static/jquery/jquery-ui/jquery-ui.min.css'/>" />
 	<link rel="stylesheet" href="<c:url value='/static/css/base.css'/>" />
	<script type="text/javascript" src="<c:url value='/static/jquery/jquery-ui/jquery-ui.js'/>"></script>
	<script type="text/javascript" src="<c:url value='/static/jquery/jquery.dataTables.min.js'/>"></script>
	<!-- End Page Specific css & javascript-->

 	<!-- START: JAVASCRIPT ROUTINES FOR SITE SPECIFIC --> 
 	<script type="text/javascript" language="javascript"> 
$(document).ready(
	function(){
	   $('.cemList').each(
	        function(){
	            $(this).text('     '+$(this).text());
	        }
	   );
 		$('#seachR').dataTable( {
 	        //"scrollY":	"250px",
 	        "paging":	false,
 	      	"bFilter": 	false,
	}); 
});
 	function display(){
 		var field = document.getElementById("cemeteryId");
 		if(field.selectedIndex == 0) {
 			document.getElementById("lnRequired").innerHTML = "<font color='red'>Required</font>";
 			document.getElementById("lnReq").innerHTML = "Required if All Cemeteries selected";
 		}else {
 			document.getElementById("lnRequired").innerHTML = "Optional"; 			
 			document.getElementById("lnReq").innerHTML = "Optional"; 			
 		}
 	}
 	function validateSearch() {
   		var field = document.getElementById("cemeteryId");
 		var name = document.getElementById("lastName");
 		if(field.selectedIndex == 0 && name.value == '') {
 			name.focus;
 			document.getElementById("searchb").src = "<c:url value='/static/gfx/disabled-main-search-button.png' />";
 			document.getElementById("searchb").disabled = true;
 			document.getElementById("searchb").style.cursor = "pointer";
 			return false;
 		}else {
 			document.getElementById("searchb").src = "http://www.cem.domain/va_files/2012/images/main-search-button.png";
 			document.getElementById("searchb").disabled = false;
 			document.getElementById("searchb").style.cursor = "hand";
 			return true;
		}
  	}

 	</script> 
 	<!-- END: JAVASCRIPT ROUTINES FOR SITE SPECIFIC --> 
<style>.cemList {text-indent: 10px}</style>
</head>

<body onload="validateSearch(); display();">
	<div id="skiplink"> <a href="#main-content">skip to page content</a></div>

	<!-- BACK GROUND WRAPPER EFFECTS -->   
	<div id="bg-main">
	<div id="bg-middle-effect"> 
	<div id="site-wrapper">

		   <!-- ************************************** START IE/EDGE META TAG   ********************************************* -->
   
	<div class="csshide">
	Attention A T users.  To access the menus on this page please perform the following steps.

		1. Please switch auto forms mode to off.
		2. Hit enter to expand a main menu option (Health, Benefits, etc).
		3. To enter and activate the submenu links, hit the down arrow.

	You will now be able to tab or arrow up or down through the submenu options to access/activate the submenu links.
	</div>

   <!-- ************************************** START HEADER   ********************************************* -->

    <div id="main-header">

        <div id="main-logo">
        <a href="http://www.domain" title="Go to VA.gov"><img src="http://www.cem.domain/va_files/2012/images/header-logo.png"  alt="Official seal of the United States Department of Veterans Affairs"></a>

        </div><!-- End main logo -->

            <div id="main-social-wrapper">
                <div class="social-wrapper-508">
                <div class="main-social-containers"><a title="Link to VA's Email Directory" href="https://public.govdelivery.com/accounts/USVA/subscriber/new"><img src="http://www.cem.domain/va_files/2012/images/social-email.png" alt="Email icon"></a></div>
                <div class="main-social-containers"><a title="Link to VA's main Facebook page" href="http://www.facebook.com/VeteransAffairs"><img src="http://www.cem.domain/va_files/2012/images/social-fb.png" alt="Facebook icon"></a></div>
                <div class="main-social-containers"><a title="Link to VA's main Twitter account" href="http://www.twitter.com/DeptVetAffairs/"><img src="http://www.cem.domain/va_files/2012/images/social-twitter.png" alt="Twitter icon"></a></div>
                <div class="main-social-containers"><a title="Link to VA's Blog VAntage Point" href="http://www.blogs.domain"><img src="http://www.cem.domain/va_files/2012/images/social-blog.png" alt="Blog icon"></a></div>
                <div class="main-social-containers"><a title="Link to VA's main Flickr account" href="http://www.flickr.com/photos/VeteransAffairs/"><img src="http://www.cem.domain/va_files/2012/images/social-flickr.png" alt="Flickr icon"></a></div>
                <div class="main-social-containers"><a title="Link to VA's main Youtube account" href="https://www.youtube.com/user/DeptVetAffairs"><img src="http://www.cem.domain/va_files/2012/images/social-youtube.png" alt="Youtube icon"></a></div>
			</div><!-- End social-wrapper-508 -->
            </div><!--End main social wrapper -->

            <div id="main-search">
             <!-- SEARCH -->

                                 <div id="search-area">
<form id="searchForm" method="GET" action="http://www.index.domain/search/va/va_search.jsp" style="margin:0px; padding:0px;">
        <script src="http://www.cem.domain/va_files/2012/scripts/Search.js" type="text/javascript"></script>

        <!-- do not insert line breaks in the div tag below -->
        <div id="mainSearchForm"><label for="searchtxt" style="position:absolute; left:-3000px;">Enter your search text</label><input name="QT" type="text" id="searchtxt" size="5" title="Enter your search text" value="" /><label style="position:absolute; left:-3000px;">Button to start search</label><input id="edit-submit" class="form-submit" type="image" src="http://www.cem.domain/va_files/2012/images/main-search-button.png" alt="Click here to submit your search" value="Search" name="submit"></div>
</form>
                                 </div>
                            <!-- END SEARCH -->


            </div><!-- End main site search -->

            <div id="main-secondary-nav">
                <ul class="secondary-nav">


                    <li><a href="http://www.domain/site_map.htm" title="Site Map A-Z">site map [a-z]</a>
                </ul>

            </div><!--End main secondary nav -->


    </div><!-- End main header -->

   <!-- ************************************** START MAIN NAVIGATION   ********************************************* -->
 <div id="top-nav-wrapper" role="navigation" aria-label="Main menu">

 <nav class="megamenu">
        <ol>
           <li> <!-- Begin Heathcare Dropdown -->
                <h2> <a href="http://www.domain/health/">Health</a></h2>
                <div class="cols-1 firstcol">
                    <ol>
                        <li class="accessible-megamenu-panel-group">
                            <ol>
                                	<li><a href="http://www.domain/health/">Health Care Information</a></li>
                         			<li><a href="http://www.domain/health/topics/">A-Z Health Topic Finder</a></li>
                         			<li><a href="http://www.myhealth.domain/">My Health<strong><em>e</em></strong>Vet</a></li>
                         			<li><a href="https://www.myhealth.domain/mhv-portal-web/anonymous.portal?_nfpb=true&amp;_pageLabel=rxRefillHome">Prescriptions Refills </a></li>
                         			<li><a href="http://www.domain/ext_redirect.asp?url=http://www.veteranscrisisline.net">Crisis Prevention</a></li>
                         			<li><a href="http://www.mentalhealth.domain/">Mental Health</a></li>
                         			<li><a href="http://www.ptsd.domain/">PTSD</a></li>
                         			<li><a href="http://www.publichealth.domain/">Public Health</a></li>
                                    <li><a href="http://www.domain/opa/choiceact/">Veterans Access, Choice &amp; Accountability Act </a></li>

                            </ol>
                        </li>
                    </ol>
                </div>
            </li> <!-- End Health Dropdown -->
            <li> <!-- Begin Benefits Dropdown -->
                <h2> <a href="http://www.benefits.domain/">Benefits</a></h2>
                <div class="cols-1">
                    <ol>
                        <li class="accessible-megamenu-panel-group">
                            <ol>
                               	    <li><a href="http://www.benefits.domain/">General Benefits Information</a></li>
                        			<li><a href="http://www.benefits.domain/compensation/">Disability Compensation</a></li>
                        			<li><a href="http://www.benefits.domain/pension/">Pension</a></li>
                        			<li><a href="http://www.benefits.domain/gibill/">GI Bill </a> <span class="registeredmark">&#174;</span></li>
                        			<li><a href="http://www.benefits.domain/vocrehab/">Vocational Rehabilitation &amp; Employment</a></li>
                        			<li><a href="https://www.ebenefits.domain/ebenefits/jobs">eBenefits Employment Center</a></li>
                        			<li><a href="http://www.benefits.domain/gibill/survivor_dependent_assistance.asp">Dependents' Educational Assistance</a></li>
                        			<li><a href="http://www.domain/opa/persona/dependent_survivor.asp">Survivor Benefits</a></li>
                        			<li><a href="http://www.benefits.domain/homeloans/">Home Loans</a></li>
                        			<li><a href="http://www.benefits.domain/insurance/">Life Insurance</a></li>
                            </ol>
                        </li>
                    </ol>
                </div>
            </li> <!-- End Benefits Dropdown Dropdown -->
            <li> <!-- Begin Burials and Memorials Dropdown -->
                <h2> <a href="http://www.cem.domain/">Burials &amp; Memorials</a></h2>
                <div class="cols-1">
                    <ol>
                        <li class="accessible-megamenu-panel-group">
                            <ol>
                                	<li><a href="http://www.cem.domain/">Cemetery Services</a></li>
                        			<li><a href="http://www.cem.domain/burial_benefits/">Burials</a></li>
                        			<li><a href="http://www.cem.domain/hmm/">Headstones Markers &amp; Medallions</a></li>
                        			<li><a href="http://www.cem.domain/pmc.asp">Presidential Memorial Certificates</a></li>
                        			<li><a href="http://www.cem.domain/cems/listcem.asp">Cemeteries</a></li>
                        			<li><a href="<c:url value='/'/>">Cemetery Burial Schedule</a></li>
	                       			<li><a href="http://gravelocator.cem.domain/">Nationwide Gravesite Locator</a></li>
                        			<li><a href="http://www.cem.domain/burial_benefits/burial_flags.asp">Burial Flags</a></li>
                        			<li><a href="http://www.cem.domain/burial_benefits/">Burial Allowance</a></li>
                            </ol>
                        </li>
                    </ol>
                </div>
            </li> <!-- EndBurials and Memorials Dropdown -->
            <li> <!-- Begin About VA -->
                <h2><a href="http://www.domain/landing2_about.htm">About VA</a></h2>
                <div class="cols-2 fifthtolast">
                    <ol>
                        <li class="accessible-megamenu-panel-group">
                            <h3><span class="panelheader">Inside VA</span></h3>
                            <ol>
                    				<li><a href="http://www.domain/opa/bios/secva.asp">Secretary of VA</a></li>
                    				<li><a href="http://www.domain/opa/bios/">Executive Biographies</a></li>
                    				<li><a href="http://www.domain/landing_organizations.htm">Organizations</a></li>
                    				<li><a href="http://www.domain/about_va/vahistory.asp">History</a></li>
                        			<li><a href="http://mycareeratva.domain/Pages/default.aspx">Careers at VA</a></li>
 
                            </ol>
                        </li>
                        <li class="accessible-megamenu-panel-group">
                            <h3><span class="panelheader">Budget and Performance</span></h3>
                            <ol>
                    				<li><a href="http://www.domain/performance/">VA Plans, Budget, &amp; Performance</a></li>
                   					<li><a href="http://www.innovation.domain/">VA Center for Innovation (VACI)</a></li>
                    				<li><a href="http://www.domain/budget/report/">Performance and Accountability Report</a></li>
                    				<li><a href="http://www.domain/budget/products.asp">Budget Submission</a></li>
                    				<li><a href="http://www.domain/recovery/">Recovery Act</a></li>
                            </ol>
                        </li>
                    </ol>
                </div>
            </li><!-- End About VA -->
            <li><!-- Begin Resources -->
                <h2><a href="http://www.domain/landing2_about.htm">Resources</a></h2>
                <div class="cols-1">
                    <ol>
                        <li class="accessible-megamenu-panel-group">
                            <ol>
                                	<li><a href="http://explore.domain/">Explore your VA Benefits</a></li>
                                	<li><a href="http://www.domain/landing2_business.htm">Business</a></li>
                    				<li><a href="http://www.domain/oca/index.asp">Congressional Affairs</a></li>
                   					<li><a href="http://www.domain/jobs/">Jobs</a></li>
                    				<li><a href="http://www.domain/opa/publications/benefits_book.asp">Benefits Booklet</a></li>
                    				<li><a href="http://www.domain/vetdata/">Data &amp; Statistics</a></li>
                    				<li><a href="https://www.ebenefits.domain/ebenefits/nrd">National Resource Directory</a></li>
									<li><a href="http://www.domain/finance/policy/gms.asp">Grants Management Services</a></li>
                                    <li><a href="http://www.domain/vso/">Veterans Service Organizations</a></li>
                                    <li><a href="http://www.diversity.domain/whistleblower.aspx">Whistleblower Rights &amp; Protections</a></li>
                            </ol>
                        </li>
                    </ol>
                </div>
            </li><!-- End Resources -->
            <li>
                <h2><a href="http://www.domain/landing2_media_room.htm">News Room</a></h2>
                <div class="cols-3 thirdtolast">
                    <ol>
                        <li class="accessible-megamenu-panel-group">
                            <h3><span class="panelheader">Inside the News Room</span></h3>
								<ol>
                                		<li><a href="http://www.domain/opa/">Public Affairs</a></li>
                                		<li><a href="http://www.domain/opa/pressrel/">News Releases</a></li>
                    					<li><a href="http://www.domain/opa/speeches/">Speeches</a></li>
                    					<li><a href="http://www.domain/opa/videos/">Videos</a></li>
                    					<li><a href="http://www.domain/opa/publications/">Publications</a></li>
                            </ol>
                        </li>
                        <li class="accessible-megamenu-panel-group">
                            <h3><span class="panelheader">National Observances</span></h3>
                            <ol>
                                	<li><a href="http://www.domain/opa/vetsday/">Veterans Day</a></li>
                     				<li><a href="http://www.domain/opa/speceven/memday/">Memorial Day</a></li>
                     				<li><a href="http://www.domain/opa/publications/celebrate_americas_freedoms.asp">Celebrating America's Freedoms</a></li>
                            </ol>
                        </li>
                        <li class="accessible-megamenu-panel-group">
                            <h3><span class="panelheader">Special Events</span></h3>
                            <ol>
                           			<li><a href="http://www.domain/adaptivesports/">Adaptive Sports Program</a>
                    				<li><a href="http://www.creativeartsfestival.domain/">Creative Arts Festival</a></li>
                    				<li><a href="http://www.domain/opa/speceven/gag/">Golden Age Games</a></li>
                    				<li><a href="http://www.domain/opa/speceven/ssc/">Summer Sports Clinic</a></li>
                    				<li><a href="http://www.domain/opa/speceven/tee/">Training &ndash; Exposure &ndash; Experience (TEE) Tournament</a></li>
                    				<li><a href="http://www.domain/opa/speceven/wcg/">Wheelchair Games</a></li>
                    				<li><a href="http://www.domain/opa/speceven/wsc/">Winter Sports Clinic</a></li>
                            </ol>
                        </li>
                    </ol>
                </div>
            </li>
            <li><!-- Begin Locations -->
                <h2><a href="http://www.domain/landing2_locations.htm">Locations</a></h2>
                <div class="cols-1 secondtolast">
                    <ol>
                        <li class="accessible-megamenu-panel-group">
                           <ol>
                                	<li><a href="http://www.domain/directory/guide/division.asp?dnum=1&amp;isFlash=0">Hospitals &amp; Clinics</a></li>
                                	<li><a href="http://www.domain/directory/guide/vetcenter.asp?isFlash=0">Vet Centers</a></li>
                               		<li><a href="http://www.domain/directory/guide/division.asp?dnum=3&amp;isFlash=0">Regional Benefits Offices</a></li>
                                	<li><a href="http://www.benefits.domain/homeloans/contact_rlc_info.asp">Regional Loan Centers</a></li>
                                	<li><a href="http://www.domain/directory/guide/division.asp?dnum=4&amp;isFlash=0">Cemetery Locations</a></li>
                            </ol>
                        </li>
                    </ol>
                </div>
            </li><!-- End Locations -->
            
             <li class="accessible-megamenu-top-nav-item last"><!-- Begin Contact Us -->
                <h2><a href="http://www.domain/landing2_contact.htm">Contact Us</a></h2>
                <div class="cols-1 last">
                    <ol>
                        <li class="accessible-megamenu-panel-group">
                            <ol>
                                	<li><a href="http://www.domain/ext_redirect.asp?url=https://iris.custhelp.com/app/answers/list">FAQs</a></li>
                                	<li><a href="http://www.domain/ext_redirect.asp?url=https://iris.custhelp.com">Ask a Question</a></li>
                                	<li><a href="http://www.domain/ext_redirect.asp?url=https://iris.custhelp.com/app/answers/detail/a_id/1703">Toll Free Numbers</a></li>
                            </ol>
                        </li>
                    </ol>
                </div>
            </li><!-- End Contact Us -->
        </ol>
    </nav>
        </div><!--/#topnav wrapper-->

<!-- include jquery -->

    

    <!-- initialize a selector as an accessibleMegaMenu -->
    <script>
        $("nav:first").accessibleMegaMenu({
            /* prefix for generated unique id attributes, which are required 
               to indicate aria-owns, aria-controls and aria-labelledby */
            uuidPrefix: "accessible-megamenu",

            menuClass: "accessible-megamenu", // default css class used to define the megamenu styling
            topNavItemClass: "accessible-megamenu-top-nav-item", // default css class for a top-level navigation item in the megamenu
            panelClass: "accessible-megamenu-panel", // default css class for a megamenu panel
            panelGroupClass: "accessible-megamenu-panel-group", // default css class for a group of items within a megamenu panel
            hoverClass: "hover", // default css class for the hover state
            focusClass: "focus", // default css class for the focus state
            openClass: "open" // default css class for the open state
        });
    </script>
    


       <!-- ************************************** END MAIN NAVIGTATION   ********************************************* -->


		<div id="container" style="clear:both">

				  <!-- ************************************** START LEFT NAVIGATION COLUMN *********************************************** -->

    <!-- ********** START LEFT NAV CONTAINER ********** -->
        <div id="leftNavContainer">

                    <!-- ********** START I AM A MENU ********** -->
                    <div id="menuIAmA"> 
                    <form name="myform" action="http://www.cem.domain/components/uri">
                    <label for="iama">I AM A...</label>
                        <div class="styled-select">
                        <select name="mydropdown" class="dropdown" onchange="location.href=(form.mydropdown.options[form.mydropdown.selectedIndex].value)" id="iama">
                            <option value="0">Select One</option>
                            <option value="http://www.domain/opa/persona/index.asp" >Veteran</option>
                            <option value="http://www.domain/opa/persona/active_duty.asp">Active Duty Service Member </option>
                            <option value="http://www.domain/opa/persona/caregiver_family.asp">Caregiver/Family Member </option>
                            <option value="http://www.domain/opa/persona/dependent_survivor.asp">Dependent/Survivor  </option> 
                            <option value="http://www.benefits.domain/guardreserve">National Guard/Reserve </option>
                            <option value="http://www.domain/opa/persona/professional_researcher.asp">Clinician/Researcher/Trainee</option>
                        </select>
                        </div>
                    </form>
                    </div>
                    <!-- ********** END I AM A MENU ********** -->
					
        <!-- ********** START LEFT NAVIGATION *************** -->

    <div id="leftNav">
    <ul class="accordion">
    
		<li><a href="http://www.cem.domain/index.asp">National Cemetery Administration</a></li>
		<li><a href="#"><span></span>Burial and Memorial Benefits</a>
			<ul class="sub-menu">
				<li><a href="http://www.cem.domain/burial_benefits/index.asp">Burial Benefits</a></li>
				<li><a href="http://www.cem.domain/burial_benefits/need.asp">Schedule a Burial</a></li>
				<li><a href="http://www.cem.domain/hmm/index.asp">Headstones, Markers and Medallions</a></li>
				<li><a href="http://www.cem.domain/pmc.asp">Presidential Memorial Certificates</a></li>
				<li><a href="http://www.cem.domain/military_funeral_honors.asp">Military Funeral Honors</a></li>
				<li><a href="http://www.cem.domain/burial_benefits/burial_flags.asp">Burial Flags</a></li>
				<li><a href="http://www.benefits.domain/benefits/factsheets/burials/Burial.pdf">Burial Allowance</a></li>
				<li><a href="http://www.domain/opa/persona/dependent_survivor.asp">Survivor's Benefits</a></li>
				<li><a href="http://www.cem.domain/Women_and_Minority_Veterans.asp">Women and Minority Veterans</a></li>
			</ul>
		</li>
		<li><a href="http://www.cem.domain/hmm/index.asp">Headstones, Markers and Medallions</a></li>
		<li><a href="http://www.cem.domain/pmc.asp">Presidential Memorial Certificates</a></li>
		<li><a href="#"><span></span>Cemetery Information</a>
			<ul class="sub-menu">
				<li><a href="http://www.cem.domain/cem/cems/index.asp">Overview</a></li>
				<li><a href="http://www.cem.domain/cem/cems/listcem.asp">Cemeteries</a></li>
				<li><a href="http://www.cem.domain/cem/grants/veterans_cemeteries.asp">State Veterans Cemeteries</a></li>
				<li><a href="http://www.cem.domain/VolunteerNCA.asp">Volunteer Opportunities</a></li>
			</ul>
		</li>
		<li><a href="http://www.cem.domain/grants/index.asp">Veterans Cemetery Grants</a></li>
		<li><a href="#"><span></span>About NCA</a>
			<ul class="sub-menu">
				<li><a href="http://www.cem.domain/design_construction/index.asp">Design and Construction Service</a></li>
				<li><a href="http://www.cem.domain/about/factsheets.asp">Fact Sheets</a></li>
				<li><a href="http://www.cem.domain/history/index.asp">History</a></li>
				<li><a href="http://www.cem.domain/about/index.asp">Leadership, Mission and Vision</a></li>
				<li><a href="http://www.cem.domain/press_room.asp">Press Room</a></li>
			</ul>
		</li>
		<li><a href="<c:url value='/'/>">Cemetery Burial Schedule</a></li>
		<li><a href="http://gravelocator.cem.domain/">Nationwide Gravesite Locator</a></li>
		<li><a href="http://www.cem.domain/faq.asp">Frequently Asked Questions</a></li>
		<li><a href="http://www.cem.domain/site_map.asp">Site Map</a></li>
	</ul>
	</div>
		<!--************ END LEFT NAVIGATION ***************-->
		
        	<!-- *********** LEFT COLUMN ADDITIONAL CONTENT AREA *************** -->

			<div id="left-col-content">

			<div class="clear"></div>
			
			<!-- <div class="administration-logo"><img src="http://www.cem.domain/CEM/images/vha-excellence.png"  height="46" width="198" alt="VHA Excellence"></div> -->   
			
          <!-- ****************** QUICK LINKS ********************** -->
          
                      <div class="widget">
                      
                        <div class="widget-title"><h4>Find a Cemetery</h4></div>
                       
                         <div id="nca-widget-locator" style="background: url(http://www.cem.domain/cem/images/bg-cemetery-locator.png) no-repeat center bottom  transparent; height:84px; width:200px; float:left;">
                         
							<div id="locator-form">
							<script  src="http://maps.google.com/maps/api/js?sensor=false" type="text/javascript"></script>
							<script language="javascript" type="text/javascript">	
								var geocoder;
								var address;		
								var url;
								var lat;
								var lng;
								var statusok="";
								function Validate() {
									var addr=trim(document.zipSearch.inputaddress.value);	
									if (addr.length==0 || addr.toLowerCase()=="zip code"){
										alert("Please enter Zip code.");
										document.zipSearch.inputaddress.focus();
										return false;
									}
									else{
										geocoder= new google.maps.Geocoder();
										address = trim(document.zipSearch.inputaddress.value);
										pgname="http://www.domain/directory/guide/Findlocations.cfm";
										
										geocoder.geocode({'address': address}, function(results, status) { 		
											if (status == google.maps.GeocoderStatus.OK) {
												point=results[0].geometry.location;	
												lat=results[0].geometry.location.lat().toFixed(6);
												lng=results[0].geometry.location.lng().toFixed(6);				
												statusok="1";	  
											}
											 else{
												statusok=status;						
											}		
										url=pgname+"?inputaddress="+address+"&FACTYPE=3&statusok="+statusok+"&latitude="+lat+"&longitude="+lng+"&SEARCH_CRITERIA=2&country=us";
										 
										window.location.href=url;    
											
										});
										return false;
									}
									
								}	
								
								function trim(str) {
									var re = /^\s+(.*?)\s+$/;
									return str.replace(re,"$1");
								} 
							    </script>
							    <form onsubmit="return Validate();" name="zipSearch" method="post" action="http://www.domain/directory/guide/FindLocations.cfm">
							    <input id="facType" type="hidden" value="3" name="FACTYPE">
							    <input id="within" type="hidden" value="2" name="SEARCH_CRITERIA">
							    <label for="LocatorPostalCode" style="position: absolute; left: -9999px;">Enter ZIP code here</label><input id="LocatorPostalCode" class="inputstyle" type="text" onfocus="this.value=''" size="10" maxlength="10" value="Zip Code" name="inputaddress" title="Enter ZIP here">
							    <div id="zipButton"><label for="zipInputButton" style="position: absolute; left: -9999px;">Enter ZIP code here</label>
							    <input id="zipInputButton" type="image" src="http://www.cem.domain/va_files/2012/images/button-locator.png" alt="Search" title="Click here to submit"></div><!-- End ZIp Button -->
							    </form> 
							</div> <!-- End Locator Form -->
                        </div><!--end nca-widget-locator -->
                      </div> <!-- end widget -->
                      
          <!-- ****************** END QUICK LINKS ********************** -->

		  			<div class="clear"></div>
			
	          <!-- ****************** SHARE ********************** -->
	          
	                      <div class="widget">
	                        
	                        <div class="widget-title"><h4>Connect with NCA</h4></div>
	                       
	                        <div id="widget-social">  
	                        
	                        <div class="widget-social-col-l">
	                            <ul>
	                            <li><a title="NCA on Facebook" href="http://www.facebook.com/NationalCemeteries"><img src="http://www.cem.domain/va_files/2012/images/social-icon-facebook-widget.png" alt="Facebook"></a></li>
	                            <li><a title="NCA on Twitter" href="http://twitter.com/VANatCemeteries"><img src="http://www.cem.domain/va_files/2012/images/social-icon-twitter-widget.png" alt="Twitter"></a></li>
	                            <li><a title="VAntage Point Blog" href="http://www.blogs.domain/VAntage/"><img src="http://www.cem.domain/va_files/2012/images/social-icon-blog-widget.png" alt="Blog"></a></li>
	                            </ul>
	                        </div><!-- End col l-->
	                        
	                        <div class="widget-social-col-r">
	                            <ul>
	                            <li><a title="VA on YouTube" href="http://www.youtube.com/user/DeptVetAffairs"><img src="http://www.cem.domain/va_files/2012/images/social-icon-youtube-widget.png" alt="Youtube"></a></li>
	                            <li><a title="VA on Flickr" href="http://www.flickr.com/photos/VeteransAffairs/"><img src="http://www.cem.domain/va_files/2012/images/social-icon-flickr-widget.png" alt="Flickr"></a></li>
	                            </ul>
	                         </div><!-- End col r -->
	                        </div><!-- End wdget social col -->
                            
                            <div id="widget-email"><!--start govdelivery signup-->
                            Subscribe to Receive<br> Email Updates
                                <form action="https://public.govdelivery.com/accounts/USVANCA/subscribers/qualify">
                                    <input id="qsp" type="hidden" value="CODE_RED" name="qsp">
                                    <label for="email_connectbox" style="position: absolute; left: -9999px;"><img alt="Required" class="required" src="https://public.govdelivery.com/images/required.gif?1215719772" />Email Address</label>
                                    <input class="email_footer" id="email_connectbox" name="email" type="text" size="10" value="Email Address" onfocus="this.value=''" title="Enter here"/>
                                    <div id="footer-email-Button">
                                    <label for="form_button" style="position: absolute; left: -9999px;">Button to subscribe to email</label>
                                    <input class="form_button" name="commit" type="image" src="http://www.cem.domain/va_files/2012/images/button-footer-email.png" alt="Click here to submit your email" value="Submit"  title="Click here to submit your email" />
                                    </div>
                                </form>
                            </div><!--end govdelivery signup-->
                            
	                      </div><!-- End social widget  -->
	                      
	          <!-- ****************** END SHARE ********************** -->

					<div class="clear"></div>

					<!-- ************************ USER WIDGET - MOBILE GRAVESITE LOCATOR ***************** -->
	 
		           <div class="widget">
		                <div class="widget-title"><h4>Mobile Gravesite Locator</h4></div>
		                    <div class="widget-user">
		                    <ul>
		                    <li>
								<p><a title="link to m.domain" href="http://m.domain/"><img align="right" width="60" height="110" alt="image link to m.domain" src="http://www.cem.domain/cem/images/ngl.jpg" border="0"></a><strong>On the go?
								<br>
								<br>
								Try our mobile gravesite locator!
								<br>
								<br>
								<a title="link to m.domain" href="http://m.domain/">m.domain</a>
								</strong></p>
								</li>
							</ul>
		                    </div><!-- End Widget User -->
		           </div><!-- end of widget -->
      
					<!-- ************************ END OF USER WIDGET - MOBILE GRAVESITE LOCATOR ***************** -->


			</div><!--End Left Col Content -->

								 <!-- *********** END OF LEFT COLUMN ADDITIONAL CONTENT AREA *************** -->
   		
  	  </div><!--End of left nav container -->
    
                   <!-- ************************************** END OF LEFT COLUMN *********************************************** -->

			<div id="mainContentWrapper">

				<a name="content-wrapper" id="content-wrapper"></a> <!-- For Skip Nav -->

				<!-- **************************** START BREADCRUMBS *********************************** -->

				<div id="breadCrumbPath"><a href="http://www.domain/">VA</a> &raquo; National Cemetery Administration</div>

				<!-- **************************** END BREADCRUMBS ************************************* -->

				<!-- ********** START SITE TITLE ********** -->
				<h1 id="site-title">National Cemetery Administration</h1>
				<!-- ********** END SITE TITLE ********** -->

			</div> <!--End main content wrapper -->
			<div id="innerContentWrapper">
				<div id="tier4innerContent">
<!-- ================================================================================================================= -->
					<div class="clear"></div>
					<c:choose>
					<c:when test="${empty resultList}">
					<a name="main-content" id="main-content">&nbsp;</a><!-- Skip Nav --></c:when>
					<c:otherwise><a name="search-content" id="search-content">&nbsp;</a><!-- Skip Nav --></c:otherwise>
					</c:choose>
					<!-- ********** START PAGE TITLE ********** -->
					<h2 class="page-title">Cemetery Burial Schedule</h2>
					<!-- ********** END PAGE TITLE ********** -->
					<form name="myForm" method="post" action="<c:url value='/'/>QuerySchedule" onsubmit="return validateSearch();">
				
						<p>To search for the burial schedule of decedents yet to be interred, please provide the following:</p>
						<p>Selecting "All" Cemeteries requires Last Name to be filled in.</p>
						<table role="presentation" class="roundedTable" border="1">
							<tr>
								<th><label for="cemeteryId">Cemetery</label></th>
								<td colspan="2">
									<select name="cemeteryId" onChange="display();  validateSearch();" id="cemeteryId">
										<option value="*">All</option>
										<c:set var="state" value="" /> 
										<c:forEach var="c" items="${cemList}" varStatus="i">
											<c:if test="${state != c.stateCd}">
												<c:if test="${i.index > 0}"></optgroup></c:if>
												<optgroup label="${c.descr}">
												<c:set var="state" value="${c.stateCd}" /> 
											</c:if>
											<option value="${c.num}" class="cemList"
											<c:if test="${cemeteryId == c.num}"> selected</c:if>
											>${c.nme}</option>
										</c:forEach>
										</optgroup>
									</select>
								</td>
							</tr>
							<tr>
								<th><label for="lastName">Last Name</label> <span id="lnReq" class="offScreen">Required if All Cemeteries selected</span></th>
								<td width="100px"><input name="lastName" value="${lastName}" id="lastName" onKeyUp="validateSearch()"/></td>
								<td width="*" id="lnRequired"><font color="red">Required</font></td>
							</tr>
							<tr>
								<th><label for="firstName">First Name</label></th>
								<td width="100px"><input name="firstName" value="${firstName}" id="firstName"/></td>
								<td width="*">Optional</td>
							</tr>
							
						</table>
						
						<p style="text-align:center;">
							<label for="search_button" style="position: absolute; left: -9999px;">Button to submit search criteria</label>
                            <input class="form_button" name="searchb" id="searchb" type="image" src="http://www.cem.domain/va_files/2012/images/main-search-button.png" alt="Click here to submit your search" value="Submit"  title="Click here to submit your search" />
						</p>
						
						<div id="sr">
						<c:if test="${not empty resultList}">
							<hr>
							<div class="clear"></div>
							<span style="position:absolute;"><a name="main-content" id="main-content">&nbsp;</a></span><!-- Skip Nav -->
							<div class="clear"></div>
							<p>Multiple results were returned.  Please select a decedent from this list or enter new <a id="skiplink" href="#search-content">search</a> criteria.</p>							
							<div class="roundPanel" style="width:90%;text-indent:16px;background-color:#EFEFEF;">
							<center>
								<table id="seachR" class="display" cellspacing="0" width="100%" border="0" style="overflow:scroll;text-indent:0px; font-size:1em" summary="Table cells are read left to right, top to bottom. ">
								 	<thead>
								 	<tr>
								 		<th scope="col">Date</th>
								 		<th scope="col">Name</th>
								 		<th scope="col">Cemetery<br/>Location</th>
								 	</tr>
								 	</thead>
								 	<tfoot>
								 	<tr>
								 		<th scope="col">Date</th>
								 		<th scope="col">Name</th>
								 		<th scope="col">Cemetery<br/>Location</th>
								 	</tr>
								 	</tfoot>
								 	<tbody>
								 <c:forEach var="r" items="${resultList}">
								 	<tr>
								 		<td wrap="nowrap"><fmt:formatDate value="${r.scheduledDateTime}" pattern="MM/dd/yyyy"/></td>
								 		<td><a href="<c:url value='/'/>QS?cemId=${r.cemeteryId}&tDate=<fmt:formatDate value="${r.scheduledDateTime}" pattern="MM/dd/yyyy"/>">${r.lastName}<c:if test="${not empty r.suffix}"> ${r.suffix}</c:if>, ${r.firstName} <c:if test="${not empty r.middleName}"> ${r.middleName}</c:if></a></td>
								 		<td>${r.cemeteryName}<br/>${r.cemeteryCity}, ${r.cemeteryState}
								 		</td>
								 	</tr>
								 </c:forEach>			 	
								 	</tbody>
								</table>
							</center>
							</div>		
							<a id="skiplink" href="#search-content" class="offScreen">back to search criteria</a>											
						</c:if>
						</div>
						<c:if test="${not empty noResults}">
						<div>
							<hr>
							${noResults}
							<a id="skiplink" href="#main-content" class="offScreen">back to search criteria</a>											
						</div>
						</c:if>
						
					</form>
<!-- ================================================================================================================= -->
				</div><!-- end of innerContent -->
				<div style="clear:both"></div>		
			</div><!-- end of innerContentWrapper -->
			

<!-- ***************************** END PAGE CONTENT **************************************** -->
       
		</div><!-- Container -->      

	</div><!-- End Site Wrapper -->
	</div><!-- End Middle Effect -->
	</div><!--End BG Main -->

	<!-- ************************************** START SITE FOOTER   ********************************************* -->

	<div id="footer-effect">

	        <div id="footer" >

	                <div  class="col">

					<h4 class="top-level">CONNECT</h4>
					<p>Veterans Crisis Line:<br>
					<span class="larger">1-800-273-8255</span> (Press 1)</p>

					<p class="h4correct">Social Media</p>

                        <div id="footer-social-wrapper">
                            <div class="main-social-containers"><a title="Link to VA's Email Directory" href="https://public.govdelivery.com/accounts/USVA/subscriber/new"><img src="http://www.cem.domain/va_files/2012/images/social-email.png" alt="Email icon"></a></div>
                            <div class="main-social-containers"><a title="Link to VA's main Facebook page" href="http://www.facebook.com/VeteransAffairs"><img src="http://www.cem.domain/va_files/2012/images/social-fb.png" alt="Facebook icon"></a></div>
                            <div class="main-social-containers"><a title="Link to VA's main Twitter account" href="http://www.twitter.com/DeptVetAffairs/"><img src="http://www.cem.domain/va_files/2012/images/social-twitter.png" alt="Twitter icon"></a></div>
                            <div class="main-social-containers"><a title="Link to VA's Blog VAntage Point" href="http://www.blogs.domain"><img src="http://www.cem.domain/va_files/2012/images/social-blog.png" alt="Blog icon"></a></div>
                            <div class="main-social-containers"><a title="Link to VA's main Flickr account" href="http://www.flickr.com/photos/VeteransAffairs/"><img src="http://www.cem.domain/va_files/2012/images/social-flickr.png" alt="Flickr icon"></a></div>
                            <div class="main-social-containers"><a title="Link to VA's main Youtube account" href="https://www.youtube.com/user/DeptVetAffairs"><img src="http://www.cem.domain/va_files/2012/images/social-youtube.png" alt="Youtube icon"></a></div>
                        </div><!--End main social wrapper -->

                        <p class="h4correct"><a href="http://www.domain/opa/socialmedia.asp" title="The complete social media directory for the Department of Veterans Affairs">Complete Directory </a></p>

					<h4 class="top-level">EMAIL UPDATES</h4>
         			 <div id="footer-email">
                         <div id="vamc_govDeliveryForm1">
                            <form action="https://public.govdelivery.com/accounts/USVA/subscribers/qualify">
                            <input id="topic_id" name="topic_id" type="hidden" value="USVA" />
                            <label for="email_footer" style="position: absolute; left: -9999px;"><img alt="Required" class="required" src="https://public.govdelivery.com/images/required.gif?1215719772" />Email Address</label>

                            <input class="email_footer" id="email_footer" name="email" type="text" size="10" value="Email Address" onfocus="this.value=''" title="Enter here"/>


                            <div id="footer-email-Button">
                            <label for="form_button" style="position: absolute; left: -9999px;">Button to subscribe to email</label>
                            <input class="form_button" name="commit" type="image" src="http://www.cem.domain/va_files/2012/images/button-footer-email.png" alt="Click here to submit your email" value="Submit"  title="Click here to submit your email" />
                            </div>
                              </form>



                 			</div>
                            

                    </div><!-- End footer email -->

        </div><!--/ .col -->

        <div  class="col">
       

                    <h4 >VA HOME</h4>

                    <ul>
                        <li><a href="http://www.domain/about_va/va_notices.asp">Notices</a></li>

                        <li><a href="http://www.oprm.domain/privacy/">Privacy</a></li>
                        <li><a href="http://www.oprm.domain/foia/">FOIA</a></li>
                        <li><a href="http://www.oprm.domain/">Regulations</a></li>
                        <li><a href="http://www.domain/webpolicylinks.asp">Web Policies</a></li>
                        <li><a href="http://www.domain/orm/NOFEAR_Select.asp">No FEAR Act</a></li>
                        <li><a href="http://www.diversity.domain/whistleblower.aspx">Whistleblower Rights &amp; Protections</a></li>
                        <li><a href="http://www.domain/general/site_map.htm">Site Index</a></li>
                        <li><a href="http://www.domain/ext_redirect.asp?url=http://www.usa.gov/">USA.gov</a></li>
                        <li><a href="http://www.domain/ext_redirect.asp?url=http://www.whitehouse.gov/">White House</a></li>
                        <li><a href="http://www.domain/oig/">Inspector General</a></li>
                    </ul>

      	</div><!--/ .col -->
        <div  class="col">

                    <h4>QUICK LIST</h4>

                    <ul>
                        <li><a href="http://www.benefits.domain/BENEFITS/Applying.asp">Apply for Benefits</a></li>
                        <li><a href="https://www.1010ez.domain.ext/sec/vha/1010ez/">Apply for Health Care</a></li>
                  		<li><a href="https://www.myhealth.domain/mhv-portal-web/anonymous.portal?_nfpb=true&amp;_pageLabel=rxRefill">Prescriptions</a></li>
				  		<li><a href="http://www.myhealth.domain/">My Health<span class="italic">e</span>Vet</a></li>
                  		<li><a href="http://www.ebenefits.domain/">eBenefits</a></li>
                  		<li><a href="http://benefits.domain/insurance/choose.asp">Life Insurance Online Applications</a></li>
                  		<li><a href="http://www.domain/vaforms/">VA Forms</a></li>
				  		<li><a href="http://www.domain/landing2_locations.htm">State and Local Resources</a></li>
				  		<li><a href="http://www.domain/op3/docs/StrategicPlanning/VA2014-2020strategicPlan.pdf">Strat Plan FY 2014&ndash;2020</a> </li>
				  		<li><a href="http://www.domain/budget/products.asp">VA 2013 Budget Submission</a></li>
  					</ul>

      	</div><!--/ .col -->
        <div  class="col">

                    <h4>RESOURCES</h4>

                    <ul>
                        <li><a href="http://mycareeratva.domain/Pages/default.aspx">Careers at VA</a></li>
                        <li><a href="https://www.ebenefits.domain/ebenefits/jobs">eBenefits Employment Center</a></li>
						<li><a href="http://www.oefoif.domain/">Returning Service Members</a></li>
						<li><a href="http://www.benefits.domain/vocrehab/index.asp">Vocational Rehabilitation &amp; Employment</a></li>
						<li><a href="http://www.domain/homeless/">Homeless Veterans</a></li>
						<li><a href="http://www.domain/womenvet/">Women Veterans</a></li>
						<li><a href="http://www.domain/centerforminorityveterans/">Minority Veterans</a></li>
                        <li><a href="http://www.domain/opa/Plain_Language.asp">Plain Language</a></li>
						<li><a href="http://www.domain/survivors/">Surviving Spouses &amp; Dependents</a></li>
						<li><a href="http://www.domain/adaptivesports/">Adaptive Sports Program</a></li>
  					</ul>

      	</div><!--/ .col -->
        <div  class="col">

					<h4>ADMINISTRATION</h4>
          			<ul>
                  		<li><a href="http://www.domain/health/default.asp">Veterans Health Administration</a></li>
                  		<li><a href="http://www.benefits.domain/benefits/">Veterans Benefits Administration</a></li>
                  		<li><a href="http://www.cem.domain/">National Cemetery Administration</a></li>
          			</ul>

      	</div><!--/ .col -->


	                <div id="sub-footer">
	                         <p>U.S. Department of Veterans Affairs | 810 Vermont Avenue, NW Washington DC 20420</p>
	                         <p class="small-print">Last updated December 1, 2014.</p>
	                </div><!--/sub-footer-->

	       </div><!--/#footer-->

	</div><!--End Footer Effect -->



</body>
</html>