package gov.va.cem.cbs.repo;

import gov.va.cem.cbs.model.UrlInformation;

import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional(readOnly=true)
public class UrlInformationDaoImpl implements UrlInformationDao {
	private static final Logger logger = LoggerFactory.getLogger(UrlInformationDaoImpl.class);

	@PersistenceContext
	private EntityManager em;

	@SuppressWarnings("unchecked")
	public UrlInformation getUrlInformationByStationNum(long stationNum, String stationType) {
		UrlInformation urlInformation = null;
		
		if (logger.isDebugEnabled()) {
			logger.debug("stationNum=" + stationNum + ", stationType=" + stationType);
		}

		Query query = em
				.createQuery(
						"Select u from UrlInformation u " + "where u.id.stationNum = ?1 "
								+ " and u.id.stationType = ?2").setParameter(1, stationNum)
				.setParameter(2, stationType);

		List<UrlInformation> list = query.getResultList();
		
		if (list == null || list.size() == 0) {
			return null;
		}

		urlInformation = (UrlInformation) list.get(0);
		
		if (logger.isDebugEnabled()) {
			logger.debug(urlInformation.toString());
		}
		
		return urlInformation;
	}

}
