package gov.va.cem.cbs.repo;

import gov.va.cem.cbs.model.CemeteryV;

import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional(readOnly=true)
public class CemeteryDaoImpl implements CemeteryDao {
	private static final Logger logger = LoggerFactory.getLogger(CemeteryDaoImpl.class);

	@PersistenceContext
	private EntityManager em;

	public CemeteryV getCemeteryByCemeteryId(String id) {
		
		logger.debug("getCemeteryByCemeteryId=" + id);
		
		CemeteryV c = em.find(CemeteryV.class, id);
		
		logger.debug(c.toString());
		
		return c;
	}

	public List<CemeteryV> getAllCemeteries() {
		List<CemeteryV> list = null;
		
		logger.debug("getAllCemeteries");

		TypedQuery<CemeteryV> query = em.createNamedQuery("CemeteryV.findAll", CemeteryV.class);
		
		list = query.getResultList();
				
		if (logger.isDebugEnabled()) {
			logger.debug("number of records=" + (list != null ? list.size() : 0));
		}

		return list;

	}

}
