package gov.va.cem.cbs.repo;

import gov.va.cem.cbs.model.BurialScheduleV;

import java.util.Date;
import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional(readOnly=true)
public class BurialScheduleDaoImpl implements BurialScheduleDao {
	private static final Logger logger = LoggerFactory.getLogger(BurialScheduleDaoImpl.class);

	@PersistenceContext
	private EntityManager em;

	@SuppressWarnings("unchecked")
	public List<BurialScheduleV> getBurialSchedule1(String cemeteryId, String lastName, String firstName) {
		List<BurialScheduleV> list = null;
		
		if (logger.isDebugEnabled()) {
			logger.debug("cemeteryId=" + cemeteryId + ", lastName=" + lastName + ", firstName=" + firstName);
		}
		
		Query query = em
				.createQuery(
						"select bs from BurialScheduleV bs " + "where bs.cemeteryId=?1 " + "and bs.lastName Like ?2 "
								+ "and bs.firstName Like ?3 "
								+ "order by bs.scheduledTimestamp, bs.lastName, bs.firstName")
				.setParameter(1, cemeteryId).setParameter(2, lastName + '%').setParameter(3, firstName + '%');
		
		list = query.getResultList();
		
		outputDebug(list);
		
		return list;
	}

	@SuppressWarnings("unchecked")
	public List<BurialScheduleV> getBurialSchedule2(String cemeteryId, String lastName) {
		List<BurialScheduleV> list = null;

		if (logger.isDebugEnabled()) {
			logger.debug("cemeteryId=" + cemeteryId + ", lastName=" + lastName);
		}
		
		Query query = em
				.createQuery(
						"select bs from BurialScheduleV bs " + "where bs.cemeteryId=?1 " + "and bs.lastName Like ?2 "
								+ "order by bs.scheduledTimestamp, bs.lastName, bs.firstName")
				.setParameter(1, cemeteryId).setParameter(2, lastName + '%');
		
		list = query.getResultList();
		
		outputDebug(list);
		
		return list;
	}

	@SuppressWarnings("unchecked")
	public List<BurialScheduleV> getBurialSchedule3(String lastName, String firstName) {
		List<BurialScheduleV> list = null;

		if (logger.isDebugEnabled()) {
			logger.debug("lastName=" + lastName + ", firstName=" + firstName);
		}
		
		Query query = em
				.createQuery(
						"select bs from BurialScheduleV bs " + "where bs.lastName Like ?1 "
								+ "and bs.firstName Like ?2 "
								+ "order by bs.scheduledTimestamp, bs.lastName, bs.firstName")
				.setParameter(1, lastName + '%').setParameter(2, firstName + '%');
		
		list = query.getResultList();
		
		outputDebug(list);
		
		return list;
	}

	@SuppressWarnings("unchecked")
	public List<BurialScheduleV> getBurialSchedule4(String lastName) {
		List<BurialScheduleV> list = null;
		
		if (logger.isDebugEnabled()) {
			logger.debug("lastName=" + lastName);
		}
		
		Query query = em.createQuery(
				"select bs from BurialScheduleV bs " + "where bs.lastName Like ?1 "
						+ "order by bs.scheduledTimestamp, bs.lastName, bs.firstName").setParameter(1, lastName + '%');
		list = query.getResultList();
		
		outputDebug(list);
		
		return list;
	}

	@SuppressWarnings("unchecked")
	public List<BurialScheduleV> getBurialSchedule5(String cemeteryId, Date targetDate) {
		List<BurialScheduleV> list = null;
		
		if (logger.isDebugEnabled()) {
			logger.debug("cemeteryId=" + cemeteryId + ", targetDate=" + targetDate);
		}
		
		Query query = em
				.createQuery(
						"select bs from BurialScheduleV bs " + "where trunc(bs.scheduledDateTime)=?1"
								+ " and bs.cemeteryId=?2 "
								+ "order by bs.scheduledTimestamp, bs.lastName, bs.firstName")
				.setParameter(1, targetDate).setParameter(2, cemeteryId);

		list = query.getResultList();
		
		outputDebug(list);
		
		return list;
	}
	
	@SuppressWarnings("unchecked")
	public List<BurialScheduleV> getBurialScheduleFirst(String cemeteryId) {
		List<BurialScheduleV> list = null;
		
		if (logger.isDebugEnabled()) {
			logger.debug("cemeteryId=" + cemeteryId);
		}
		
		Query query = em.createQuery(
				"select bs from BurialScheduleV bs " + "where trunc(bs.scheduledDateTime)= "
				+ " (select trunc(min(b.scheduledDateTime)) from BurialScheduleV b where b.cemeteryId=?1)"
				+ " and bs.cemeteryId=?1 "
				+ " order by bs.scheduledTimestamp, bs.lastName, bs.firstName");
		
		query.setParameter(1, cemeteryId);

		list = query.getResultList();
		
		outputDebug(list);
		
		return list;
	}

	private void outputDebug(List<BurialScheduleV> list) {
		if (logger.isDebugEnabled()) {
			logger.debug("number of records=" + (list != null ? list.size() : 0));
			
			if (list != null) {
				for (BurialScheduleV s : list) {
					logger.debug(s.toString());
				}
			}
		}
	}
}
