package gov.va.cem.cbs.model;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Embeddable;

/**
 * The primary key class for the URL_INFORMATION database table.
 * 
 */
@Embeddable
public class UrlInformationPK implements Serializable {
	//default serial version id, required for serializable classes.
	private static final long serialVersionUID = 1L;

	@Column(name="STATION_NUM")
	private long stationNum;

	@Column(name="STATION_TYPE")
	private String stationType;

	public UrlInformationPK() {
	}
	public long getStationNum() {
		return this.stationNum;
	}
	public void setStationNum(long stationNum) {
		this.stationNum = stationNum;
	}
	public String getStationType() {
		return this.stationType;
	}
	public void setStationType(String stationType) {
		this.stationType = stationType;
	}

	public boolean equals(Object other) {
		if (this == other) {
			return true;
		}
		if (!(other instanceof UrlInformationPK)) {
			return false;
		}
		UrlInformationPK castOther = (UrlInformationPK)other;
		return 
			(this.stationNum == castOther.stationNum)
			&& this.stationType.equals(castOther.stationType);
	}

	public int hashCode() {
		final int prime = 31;
		int hash = 17;
		hash = hash * prime + ((int) (this.stationNum ^ (this.stationNum >>> 32)));
		hash = hash * prime + this.stationType.hashCode();
		
		return hash;
	}
	@Override
	public String toString() {
		return "UrlInformationPK [stationNum=" + stationNum + ", stationType=" + stationType + "]";
	}
	
	
}